#include    "circular_buffer.h"
#include    "mbed.h"

using namespace std;

bool    circular_buffer_f::seek    (int distance_back) {   // Assumes at least that much has been written to buff beforehand
    if(!seek_enable)    return  false;
    if(buffsize <= distance_back)    return  false;
    Offbuff = Onbuff - distance_back;       //  Setup to enable read of most recent 'distance_back' samples
    if(Offbuff < buffbase)  Offbuff += buffsize;
    emptyf = false;
    return  true;
}
void    circular_buffer_f::init    (int size, float *buffstart, int flags)  {  // Size and address of buffer to work with
    buffsize = size;
    Onbuff = Offbuff = buffend = buffbase = buffstart;
    buffend += (size - 1);
    emptyf = true; fullf = false;
    if  (flags & OVERWRITE_ENABLE)  overwrite_enable = true;
    else overwrite_enable = false;
    if  (flags & SEEK_ENABLE)       seek_enable = true;
    else seek_enable = false;
}
bool    circular_buffer_f::read (float *rd)  {
    if(!readable())             return false;
    *rd = *Offbuff++;
    if(Offbuff > buffend)       Offbuff = buffbase;
    if(Onbuff == Offbuff)       emptyf = true;
    fullf = false;
    return true;
}
bool    circular_buffer_f::write   (float a)  {     // Put value into circular buffer
    if  (overwrite_enable)  {
        *Onbuff++ = a;                  // post increment pointer
        if(Onbuff > buffend)        Onbuff = buffbase;
        fullf = false;
    }
    else    {
        if(fullf)                   return false;  // Fail if buffer already full
        *Onbuff++ = a;                  // post increment pointer
        if(Onbuff > buffend)        Onbuff = buffbase;
        if(Onbuff == Offbuff)       fullf = true;
    }
    emptyf = false;
    return true;
}
bool circular_buffer_f::get_samps (float *dest, int len) {
    for (int i = 0; i < len; i++)   {
        if (!read(dest++))
            return false;
    }
    return  true;
}

//////////////////////////

bool    circular_buffer_c::seek    (int distance_back) {   // Assumes at least that much has been written to buff beforehand
    if(!seek_enable)    return  false;
    if(buffsize <= distance_back)    return  false;
    Offbuff = Onbuff - distance_back;       //  Setup to enable read of most recent 'distance_back' samples
    if(Offbuff < buffbase)  Offbuff += buffsize;
    emptyf = false;
    return  true;
}
void    circular_buffer_c::init    (int size, char *buffstart, int flags)  {  // Size and address of buffer to work with
    buffsize = size;
    Onbuff = Offbuff = buffend = buffbase = buffstart;
    buffend += (size - 1);
    emptyf = true; fullf = false;
    if  (flags & OVERWRITE_ENABLE)  overwrite_enable = true;
    else overwrite_enable = false;
    if  (flags & SEEK_ENABLE)       seek_enable = true;
    else seek_enable = false;
}
bool    circular_buffer_c::read (char *rd)  {
    if(!readable())             return false;
    *rd = *Offbuff++;
    if(Offbuff > buffend)       Offbuff = buffbase;
    if(Onbuff == Offbuff)       emptyf = true;
    fullf = false;
    return true;
}
bool    circular_buffer_c::write   (char a)  {     // Put value into circular buffer
    if  (overwrite_enable)  {
        *Onbuff++ = a;                  // post increment pointer
        if(Onbuff > buffend)        Onbuff = buffbase;
        fullf = false;
    }
    else    {
        if(fullf)                   return false;  // Fail if buffer already full
        *Onbuff++ = a;                  // post increment pointer
        if(Onbuff > buffend)        Onbuff = buffbase;
        if(Onbuff == Offbuff)       fullf = true;
    }
    emptyf = false;
    return true;
}
bool circular_buffer_c::get_samps (char *dest, int len) {
    for (int i = 0; i < len; i++)   {
        if (!read(dest++))
            return false;
    }
    return  true;
}

