#include "mbed.h"
#include <cctype>
using namespace std;
enum    {FWD, REV}  ;
//typedef float  fl_typ;  //  
typedef double  fl_typ;  //  
struct  singleGparam    {
    float          flt;
    unsigned long   ul;
    int         i,  c;
    bool            changed;
}   ;

//  Cleaned up version for use without RTOS
extern  Serial pc;

void    setpwm_cmd (struct singleGparam * a)   {
    //a[1].i  //  first param
    pc.printf   ("First %d, second %d\r\n", a[1].i, a[2].i);
//??    set_pwm   (a[1].i);
}

extern  int SD_card_erase_all   (void)  ;   //  assumes sd card is 4 Gbyte, erases 4 Gbyte.
void    erase_SD_cmd (struct singleGparam * a)   {
    SD_card_erase_all   ()  ;
}

void    setvref_cmd (struct singleGparam * a)   {
    //a[1].i  //  first param
    pc.printf   ("First %d, second %d\r\n", a[1].i, a[2].i);
//??    set_I_limit   (a[1].i);
}

/*
void    setmotpwm_cmd (struct singleGparam * a)   {
    //a[1].i  //  first param
    pc.printf   ("First %d, second %d\r\n", a[1].i, a[2].i);
//    set_motor_pwm   (a[1].i, a[2].i);
}
//extern  void    set_fwd_rev (int direction) ;
void    set_fwd_cmd (struct singleGparam * a)   {
//    set_fwd_rev   (FWD);
}
void    set_rev_cmd (struct singleGparam * a)   {
//    set_fwd_rev   (REV);
}

void    set_speed_cmd (struct singleGparam * a)   {
    pc.printf   ("Speed entered %d\r\n", a[1].i);
}

void    read_current_cmd (struct singleGparam * a)   {
    pc.printf   ("Read current\r\n");
}
*/
void    menucmd (struct singleGparam * a);

struct kb_command  {
    const char * cmd_word;         //  points to text e.g. "menu"
    const char * explan;
    void (*f)(struct singleGparam *);   //  points to function
}  ;

struct  kb_command const command_list[] = {
    {"menu", "Lists available commands, same as ls", menucmd},
    {"ls", "Lists available commands, same as menu", menucmd},
    {"pw", "set pwm 0 to 999", setpwm_cmd},
    {"vref", "set vref 0 to 999", setvref_cmd},
    {"sd erase", "set motors in one direction", erase_SD_cmd},
//    {"rev", "set motors in tother direction", set_rev_cmd},
//    {"s", "set speed", set_speed_cmd},
//    {"i", "Read motor currents", read_current_cmd},
};

const int numof_menu_items = sizeof(command_list) / sizeof(kb_command);
void    menucmd (struct singleGparam * a)
{
    pc.printf("\r\n\nLoco_TS_2017\r\nAt menucmd function - listing commands:-\r\n");
    for(int i = 0; i < numof_menu_items; i++)
        pc.printf("[%s]\t\t%s\r\n", command_list[i].cmd_word, command_list[i].explan);
    pc.printf("End of List of Commands\r\n");
}


void    grain_clr   (struct singleGparam & g)  {
    g.flt = 0.0;
    g.ul = 0L;
    g.i = g.c = 0;
    g.changed = false;
}

//void    command_line_interpreter    (void const * name)
void    command_line_interpreter    ()
{
const int MAX_PARAMS = 10, MAX_CMD_LEN = 120;
static  char    cmd_line[MAX_CMD_LEN + 4];
static  struct  singleGparam   params[MAX_PARAMS + 1];
static  int     cl_index = 0, lastalpha = 0;
static  fl_typ  fracmul;
int ch;
////No RTOS    while   (true)  {
        while  (pc.readable()) {
            ch = tolower(pc.getc());
           // pc.printf("%c", ch);
            if  (cl_index > MAX_CMD_LEN)  {   //  trap out stupidly long command lines
                pc.printf   ("Error!! Stupidly long cmd line\r\n");
                cl_index = 0;
            }
            if  (ch == '\r' || ch >= ' ' && ch <= 'z')
                pc.printf("%c", ch);
            else    {                   //  Using <Ctrl>+ 'F', 'B' for Y, 'L', 'R' for X, 'U', 'D' for Z
                cl_index = 0;           //                 6    2          12   18         21   4
                pc.printf("[%d]", ch);
                //nudger  (ch); //  was used on cnc to nudge axes a tad
            }
            if(ch != '\r')  //  was this the 'Enter' key?
                cmd_line[cl_index++] = ch;  //  added char to command being assembled
            else    {   //  key was CR, may or may not be command to lookup
                cmd_line[cl_index] = 0; //  null terminate command string
                if(cl_index)    {   //  If have got some chars to lookup
                    int i, wrdlen;
                    for (i = 0; i < numof_menu_items; i++)   {   //  Look for input match in command list
                        wrdlen = strlen(command_list[i].cmd_word);
                        if(strncmp(command_list[i].cmd_word, cmd_line, wrdlen) == 0
                            && !isalpha(cmd_line[wrdlen]))  {   //  If match found
                            bool negflag = false;
                            int state = 0, paramindex;
    //                            pc.printf("Found match for word [%s]\r\n", kbc[i].wrd);
                            for(paramindex = 0; paramindex < MAX_PARAMS; paramindex++) 
                                grain_clr   (params[paramindex]);
                            paramindex = 0;
                            //  read any parameters from command line here
                            //  Using parameters[0] as count of parameters to follow
                            while   (wrdlen <= cl_index)  {
                                ch = cmd_line[wrdlen++];
                                if(isalpha(ch)) lastalpha = ch;
                                if(ch == '-')   negflag = true;
                                if(ch == '+')   negflag = false;
                                switch  (state) {
                                    case    0:  //  looking for start of a number string
                                        if(isdigit(ch)) {   //  found first digit of a number string
                                            paramindex++;
                                            if(paramindex > MAX_PARAMS)    {
                                                wrdlen = cl_index;  //  exit condition
                                                pc.printf("WARNING - too many parameters, ignoring extra\r\n");
                                            } else    {
                                                params[paramindex].i = ch - '0';
                                                params[paramindex].c = lastalpha;
                                                state = 1;  //  Found first digit char of number string
                                            }
                                        }
                                        break;
                                    case    1:  //  looking for end of a number string
                                        if(isdigit(ch)) {   //  accumulating integer from string
                                            params[paramindex].i *= 10;
                                            params[paramindex].i += ch - '0';
                                        } else    { //  found non-digit terminating number
                                            if  (ch == '.')  {
                                                state = 2;
                                                fracmul = 0.1;
                                                params[paramindex].flt = (fl_typ)params[paramindex].i;
                                            } else    {
                                                params[0].i++;    //  count of validated parameters
                                                state = 0;  //  Have read past last digit of number string
                                                if(negflag) {
                                                    params[paramindex].i = -params[paramindex].i;
                                                    negflag = false;
                                                }
                                                params[paramindex].flt = (fl_typ)params[paramindex].i;
                                            }
                                        }
                                        break;
                                    case    2:  //  looking for fractional part of double
                                        if(isdigit(ch)) {   //  accumulating fractional part from string
                                            params[paramindex].flt += (fl_typ)((ch - '0') * fracmul);
                                            fracmul /= 10.0;
                                        } else    { //  found non-digit terminating double precision number
                                            params[0].i++;    //  count of validated parameters
                                            state = 0;  //  Have read past last digit of number string
                                            if(negflag) {
                                                params[paramindex].i = -params[paramindex].i;
                                                params[paramindex].flt = -params[paramindex].flt;
                                                negflag = false;
                                            }
                                        }
                                        break;
                                    default:
                                        break;
                                }   //  end of switch state
                            }       //  end of while wrdlen < cl_index
    //                            pc.printf("Found match to [%s] with %d parameters\r\n", command_list_ptr[i].wrd, paramindex);
                            command_list[i].f(params);   //  execute command
                            i = numof_menu_items + 1;    //  to exit for loop
                        }
                    }       // End of for numof_menu_items
                    if(i == numof_menu_items)
                        pc.printf("No Match Found for CMD [%s]\r\n", cmd_line);
                }           //  End of If have got some chars to lookup
                pc.printf("\r\n>");
                cl_index = lastalpha = 0;
            }               // End of else key was CR, may or may not be command to lookup
        }                   //  End of while (pc.readable())
//No RTOS        osThreadYield();  //  Using RTOS on this project
//    }
}


