/*
This file about using model control servo to drive the throttle of Honda GX120 engine

Using a model control servo to set the throttle of Honda GX120 petrol engine
First thoughts  12 Nov 2017.

Servo driven by positive pulse of duration 1000 to 2000 micro sec. Repetition rate 50Hz
Will first try repeating in 32ms loop giving repetirion rate approx 30 Hz.
Pos pulse generated by setting to 1 in 32ms handler and starting a 'timeout'

    ... as part of 32ms code
    if  (torque_demand < 0.01)  {
        throttle    (TICKOVER);
    }
    else    {   //  got positive torque demand
        throttle    (MID_REVS);
    }
    throttle_servo_pulse_out = 1;
    throttle_servo_pulse_width.attach_us    (&servo_pulse_lo, global_throttle_us);
*/
#include "mbed.h"
#include "Electric_Loco.h"

static const   int
    SERVO_RANGE     = 1000, //  micro sec difference between max and min
    SERVO_OFFSET    = 1000, //  min servo pulse width micro sec
    TICKOVER        = SERVO_OFFSET + 0,
    MID_REVS        = SERVO_OFFSET + 500,
    RANGE_MULTIPLIER    = SERVO_RANGE + SERVO_OFFSET - MID_REVS;

DigitalOut  throttle_servo_pulse_out    (D8);   //  now defined in throttle.cpp

Timeout throttle_servo_pulse_width;

void    throttle_servo_pulse_lo  ()  {   //  Interrupt handler called at end of 'Timeout'
    throttle_servo_pulse_out = 0;   //  end servo positive pulse
}

int throttle    (double torque_demand, double speed_mph)    {   //  called from main every 31ms
    int duration_us;
    if  (throttle_servo_pulse_out != 0)
        return  -1; //  pulse positive already
    if  (torque_demand < 0.01)  {
        duration_us = TICKOVER;
    }
    else    {   //  got positive torque demand
        double  tmpd = torque_demand * RANGE_MULTIPLIER;
        duration_us = MID_REVS + (int) tmpd;
    }
    throttle_servo_pulse_out = 1;   //  start servo positive pulse
    throttle_servo_pulse_width.attach_us    (&throttle_servo_pulse_lo, duration_us);
    return  0;
}
//  endof New Nov 2017    Controlling throttle of Honda engine


