#include "mbed.h"
/*
Purpose of this file is to provide sin and cos functions. Yes, C++ has these already, but using inbuilt sin and cos on
DISCO-F746NG causes display to flicker! Interrupt getting missed or whatever, these look-up functions solve the flicker !
*/
static const double HALF_PI = 2.0 * atan(1.0);
static const double TWO_PI  = 8.0 * atan(1.0);

double  jcos    (double angle)  {
//At costabgen with 180 points
static const double costab[] = {
+1.000000, +0.999962, +0.999848, +0.999657, +0.999391, +0.999048, +0.998630, +0.998135,
+0.997564, +0.996917, +0.996195, +0.995396, +0.994522, +0.993572, +0.992546, +0.991445,
+0.990268, +0.989016, +0.987688, +0.986286, +0.984808, +0.983255, +0.981627, +0.979925,
+0.978148, +0.976296, +0.974370, +0.972370, +0.970296, +0.968148, +0.965926, +0.963630,
+0.961262, +0.958820, +0.956305, +0.953717, +0.951057, +0.948324, +0.945519, +0.942641,
+0.939693, +0.936672, +0.933580, +0.930418, +0.927184, +0.923880, +0.920505, +0.917060,
+0.913545, +0.909961, +0.906308, +0.902585, +0.898794, +0.894934, +0.891007, +0.887011,
+0.882948, +0.878817, +0.874620, +0.870356, +0.866025, +0.861629, +0.857167, +0.852640,
+0.848048, +0.843391, +0.838671, +0.833886, +0.829038, +0.824126, +0.819152, +0.814116,
+0.809017, +0.803857, +0.798636, +0.793353, +0.788011, +0.782608, +0.777146, +0.771625,
+0.766044, +0.760406, +0.754710, +0.748956, +0.743145, +0.737277, +0.731354, +0.725374,
+0.719340, +0.713250, +0.707107, +0.700909, +0.694658, +0.688355, +0.681998, +0.675590,
+0.669131, +0.662620, +0.656059, +0.649448, +0.642788, +0.636078, +0.629320, +0.622515,
+0.615661, +0.608761, +0.601815, +0.594823, +0.587785, +0.580703, +0.573576, +0.566406,
+0.559193, +0.551937, +0.544639, +0.537300, +0.529919, +0.522499, +0.515038, +0.507538,
+0.500000, +0.492424, +0.484810, +0.477159, +0.469472, +0.461749, +0.453990, +0.446198,
+0.438371, +0.430511, +0.422618, +0.414693, +0.406737, +0.398749, +0.390731, +0.382683,
+0.374607, +0.366501, +0.358368, +0.350207, +0.342020, +0.333807, +0.325568, +0.317305,
+0.309017, +0.300706, +0.292372, +0.284015, +0.275637, +0.267238, +0.258819, +0.250380,
+0.241922, +0.233445, +0.224951, +0.216440, +0.207912, +0.199368, +0.190809, +0.182236,
+0.173648, +0.165048, +0.156434, +0.147809, +0.139173, +0.130526, +0.121869, +0.113203,
+0.104528, +0.095846, +0.087156, +0.078459, +0.069756, +0.061049, +0.052336, +0.043619,
+0.034899, +0.026177, +0.017452, +0.008727, +0.000000, 0.0      }       ;
//End of costab
    const int costab_points_i = (sizeof(costab) / sizeof(double)) - 1;
    const double costab_points_d = (double) costab_points_i;
    bool    isneg = false;
    int     offset;
    while   (angle > TWO_PI)    angle   -= TWO_PI;
    while   (angle < 0.0)       angle   += TWO_PI;
            //  now got 0.0 <= angle <= 2PI
    offset  = (int)(angle * costab_points_d / HALF_PI);    //  ang2 is 0.0 <= ang2 <= 2.0 * PI
    if      (offset > 3 * costab_points_i) {   //  quadrant = 3;
            offset = (4 * costab_points_i) - offset - 1;
    }
    else if (offset > 2 * costab_points_i) {   //  quadrant = 2;
            offset -= 2 * costab_points_i;
            isneg = true;
    }
    else if (offset > 1 * costab_points_i) {   //  quadrant = 1;
            offset = (2 * costab_points_i) - offset - 1;
            isneg = true;
    }                                           //    else    quadrant = 0;
    if  (offset < 0)                offset = 0;
    if  (offset > costab_points_i)  offset = costab_points_i;
    if  (isneg) return  - costab[offset];
    else        return  costab[offset];
}

double  jsin    (double angle)  {
    return  -jcos    (angle + HALF_PI);
}


