/*  Updated 12 Nov 2017
    Jon Freeman

  5" and 7.25" gauge Electric Locomotive Controller - ST DISCO-F746NG
Uses built in display and touch screen.

Display shows 'analogue' moving coil meter movements for :
    Locomotive speed Miles per Hour
    System voltage (range 20v - 90v or thereabouts)
    Power Watts delivered to drive motors.

Touch screen has three 'buttons', these are currently unused, and are where the meter movements show.
Idea is to use two for two horns,

Display has 'slider' touch control. This drives the loco.
Control in central position when not driving or drfting.
Moving towards bottom of screen applies regenerative braking - move further down applies harder braking.
Moving towards top of screen powers drive motors, move further up applies more torque (current controller implemented)
Take finger off and control drifts down to central 'neutral' position.
*/
#define MAX_TOUCHES 6       //  Touch screen can decode up to this many simultaneous finger press positions
#define NEUTRAL_VAL   150   //  Number of pixels

#define SLIDERX 418         //  slider graphic x position
#define SLIDERY 2           //  slider graphic y position
#define SLIDERW 50          //  pixel width of slider
#define SLIDERH 268         //  pixel height of slider

//  To get speedo reading correctly, need to use correct gear ratio and wheel size info
//#define BOGIE_5_INCH
#define BOGIE_7_and_a_quarter_INCH

const   int

    NUMBER_OF_MOTORS    = 4,    //  1 to 6 motors

    BUTTON_RAD  = (SLIDERW / 2) - 4,    //  radius of circular 'knob' in slider control
    MIN_POS     = BUTTON_RAD + 5,               //  top of screen
    MAX_POS     = SLIDERH - (BUTTON_RAD + 1),   //  bottom of screen
    CIRC_CTR = SLIDERX + BUTTON_RAD + 4;

static const double
#ifdef  BOGIE_7_and_a_quarter_INCH
    MOTOR_PINION_T  = 17.0, //  motor pinion teeth, wheel gear teeth and wheel dia required to calculate speed and distance.
    WHEEL_GEAR_T    = 76.0,
    WHEEL_DIA_MM    = 147.0,
#endif
#ifdef  BOGIE_5_INCH
    MOTOR_PINION_T  = 27.0, //  motor pinion teeth, wheel gear teeth and wheel dia required to calculate speed and distance.
    WHEEL_GEAR_T    = 85.0,
    WHEEL_DIA_MM    = 98.0,
#endif
    PI = 4.0 * atan(1.0),
    WHEEL_CIRCUMFERENCE_METRE = PI * WHEEL_DIA_MM / 1000.0,
    PULSES_PER_WHEEL_REV    = 32.0 * WHEEL_GEAR_T / MOTOR_PINION_T,
    PULSES_PER_METRE        = PULSES_PER_WHEEL_REV / WHEEL_CIRCUMFERENCE_METRE,
    rpm2mph         = 60.0                                      //  = Motor Revs per hour;
                  * (MOTOR_PINION_T / WHEEL_GEAR_T)   //  = Wheel rev per hour
                  * WHEEL_CIRCUMFERENCE_METRE         //  = metres per hour
                  * 39.37                             //  = inches per hour
                  / (1760 * 36)                       //  = miles per hour
                  ;

const   double LOCO_HANDBRAKE_ESCAPE_SPEED = 0.5;

enum    {NO_DPS, ONE_DP};
//  Assign unique number to every button we may use, and keep count of total number of them
enum        {
            ENTER, SLIDER, SPEEDO_BUT, VMETER_BUT, AMETER_BUT,
            NUMOF_BUTTONS}  ;   //  button names
enum        {
            STATES, INACTIVE, RUN, NEUTRAL_DRIFT, REGEN_BRAKE, PARK, HANDBRAKE_SLIPPING};

struct  slide   {   int position;    int    oldpos; int state; int direction;   bool recalc_run;    bool handbrake_slipping;    
                    double handbrake_effort;   double   loco_speed;  }   ;
struct  point   {   int x;    int y;  }   ;
//struct  rect    {   struct point a, b; }   ;
struct  key     {   int keynum; int x;  int y;  bool pressed;  }   ;
struct  ky_bd   {   int count,  slider_y; key ky[MAX_TOUCHES + 1];   bool  sli;   }  ;

