#ifndef JON_FREEMAN_MOVING_COIL_METER
#define JON_FREEMAN_MOVING_COIL_METER
#include "mbed.h"

/**
class    moving_coil_meter
Create moving coil meter graphic using STM32F746G-DISCO.
Usage example :

top line of constructor :
moving_coil_meter::moving_coil_meter   (    int bod_col, int bgcol, int needlecol, int textcol, int scalecol,
                                            int cx, int cy, int size, double lo, double hi, double start_ang, double end_ang, 
                                            int scaleticks, char * units, int decimal_places, bool sign)

moving_coil_meter   Voltmeter   (   LCD_COLOR_BLACK,    //  Frame / body colour
                                    LCD_COLOR_WHITE,    //  Dial face colour
                                    LCD_COLOR_RED,      //  Moving needle colour
                                    LCD_COLOR_BLUE,     //  Text colour for Units e.g. 'V' and e.g. '32.7'
                                    LCD_COLOR_MAGENTA,  //  Scale graduations colour
                                    VOLTMETER_X,        //  X co-ord, centre of meter
                                    VOLTMETER_Y,        //  Y co-ord, centre of meter
                                    V_A_SIZE,           //  Meter is square with rounded corners. This is meter dial face radius
                                    22.0,               //  Scale not limited to e.g. 0 to 10. This is reading at anti-clock limit
                                    59.0,               //  This is reading at full scale deflection
                                    1.25 * PI,          //  Angle of needle at anti-clockwise limit
                                    -0.25 * PI ,        //  Angle of needle at full scale deflection (clockwise max)
                                    30,                 //  Number of scale graduation marks drwan
                                    "V",                //  Text for Units, e.g. 'V' or 'MPH'
                                    ONE_DP,             //  NO_DPS or ONE_DP - supports only no decimal places or one
                                    false) ;            //  true to show '+' or '-', false to supress sign display

*/
class    moving_coil_meter
{
    int     meter_radius, cent_x, cent_y, needle_len, scale_ticks,
            disc_colour,    needle_colour,  scale_colour,   text_colour, body_colour, dec_places;
    int corner_rad,         //          = (meter_radius / 6),
        screw_hole_offset,  //   = (meter_radius * 92 / 100),
        screw_rad   ;       //           = (meter_radius / 13);
    char    unit_txt[8];
    double  start_angle, end_angle, old_angle, value_min, value_max, swept_angle, value_range;
    bool    draw_sign;

    void    DrawNeedle          (double alpha, int colour)  ;
    double  get_pointer_angle   (double value)  ;
    int     get_font_size       ()  ;

public:
    moving_coil_meter   () {} ;//  default constructor
    moving_coil_meter   (int, int, int, int, int, int, int, int, double, double, double, double, int, char *, int, bool) ;
    void    set_value   (double v)  ;
    void    redraw  ()  ;
    void    LED (int, int)  ;
}   ;

#endif
