#include "mbed.h"
#ifndef MBED_JONS_RADIO_CONTROL_IN_H
#define MBED_JONS_RADIO_CONTROL_IN_H
#include    "brushless_motor.h"
extern  const   uint32_t    MOTOR_HANDBRAKE, MOTOR_FORWARD, MOTOR_REVERSE, MOTOR_REGENBRAKE;

/**class   RControl_In
    Jon Freeman
    Jan 2019

    Checks for __-__ duration 800-2200us
    Checks repetition rate in range 5-25ms
*/
class   RControl_In         //  Class to Read servo style pwm input _____-_____
{
    InterruptIn pulse_in;
    Timer   t;
    int32_t pulse_width_us, period_us, pulse_count, tmp;
    uint32_t state, chan_mode, stick_sense;               //  New Dec 2019
    double  norm, V, I, stick_deviation, stick_deviation_old;          //  New Dec 2019
    double  lost_chan_return_value, brake_segment, effort, stick_attack;
    double  range_offset;
    void    RadC_rise ();
    void    RadC_fall ();
public:
    RControl_In   (PinName inp) : pulse_in(inp)   {    //  Constructor
        pulse_in.mode   (PullDown);
        pulse_in.rise(callback(this, &RControl_In::RadC_rise));     // Attach handler to the rising interruptIn edge
        pulse_in.fall(callback(this, &RControl_In::RadC_fall));     // Attach handler to the falling interruptIn edge
        pulse_width_us = period_us = pulse_count = stick_sense = tmp = 0;
        state = MOTOR_REGENBRAKE;   //  New Dec 2019
        norm = V = I = stick_deviation = stick_deviation_old = 0.0;          //  New Dec 2019
        lost_chan_return_value = 0.0;
        range_offset = 0.0;
        stick_attack = 0.5;
    }   ;
    bool        validate_rx ()  ;   //  Informs whether signal being rx'd
    void        set_lost_chan_return_value  (double)  ; //  set what 'normalised' returns when no signal
    void        set_offset  (signed char, char, char);  //  signed char offs, char brake_pcent, char attack
    void        set_chanmode    (char, char);   //  1 Disable, Uni, Bi;    2 norm/rev
    uint32_t    get_chanmode    ()  ;
    uint32_t    pulsecount  ()  ;   //  will count up at frame rate when radio control all working well
    uint32_t    pulsewidth  ()  ;   //  
    uint32_t    period      ()  ;   //  checked for believable repetition rate
    bool        read    (struct  RC_stick_info &)  ;
    bool        energise    (struct  RC_stick_info &, struct brushless_motor &)  ;
}   ;

#endif
