/*  mbed brushless_motor library
    Jon Freeman
    December 2018
*/
#ifndef MBED_BRUSHLESSMOTOR_H
#define MBED_BRUSHLESSMOTOR_H

#include "mbed.h"
#include "STM3_ESC.h"
#include "FastPWM.h"

class   brushless_motor
{
    int32_t     angle_cnt;
    uint32_t    Hall_index[2], encoder_error_cnt, motor_poles, current_sense_rs_offset;
    uint32_t    Hall_total,         //  Incremented on every Hall sensor transition
                Hall_previous,
                visible_mode,       //  One of MOTOR_HANDBRAKE, MOTOR_FORWARD, MOTOR_REVERSE, MOTOR_REGENBRAKE
                inner_mode; 
    uint32_t    direction;
    double      RPM_filter;     //, dv_by_dt;
    bool        moving_flag;
    const       uint16_t * lut;
    AnalogIn    Motor_I;
    FastPWM     maxV,   maxI;
    InterruptIn H1, H2, H3;     //  Inputs for motor Hall sensors
    PortOut     OP;
    void        motor_voltage_refresh   ()  ;
    void        Hall_change ()  ;
    uint32_t    read_Halls  ()  ;           //  Returns 3 bits of latest Hall sensor outputs
//    uint32_t    max_rpm ;
    double      V_clamp ;   //  Used to limit top speed
//    double      numof_current_sense_rs;
    double      last_V, last_I, current_scale;
public:
    uint32_t    tickleon;
    double      Idbl;
    double      dRPM, dMPH;
                                
//    brushless_motor   ()  {}   ;  //  can not use this with exotic elements PortOut, FastPWM etc
    brushless_motor   (PinName iadc, PinName pwv, PinName pwi, const uint16_t *, PinName h1, PinName h2, PinName h3, PortName, const uint16_t, const uint32_t)   ;   //  Constructor
    bool        poles       (uint32_t)   ;   //  Set number of motor poles - 4, 6, or 8
    void        set_V_limit (double)    ;  //  Sets max motor voltage
    void        set_I_limit (double)    ;  //  Sets max motor current
    void        motor_set   ()  ;           //  Energise Port with data determined by Hall sensors
    void        set_direction   (uint32_t)  ;    //  sets 'direction' with bit pattern to eor with MOTOR_FORWARD or MOTOR_REVERSE in set_mode
    void        brake   (double brake_effort)    ;
//    uint32_t    get_direction   ()  ;
    bool        set_mode    (uint32_t);          //  sets mode to MOTOR_HANDBRAKE, MOTOR_FORWARD, MOTOR_REVERSE or MOTOR_REGENBRAKE
    uint32_t    get_mode    ()    ;
    bool        is_moving   ()  ;           //  Returns true if one or more Hall transitions within last 31.25 milli secs
    void        speed_monitor_and_control   ()  ;  //  call this once per main loop pass (32Hz) to keep count = edges per sec
    void        high_side_off   ()  ;
//    void    low_side_on     ()  ;
    void        sniff_current   ()  ;           //  Call this every 200us to update Idbl
    void        I_scale (double);
    bool        exists  ()  ;       //  New May 2020 - reports presence or absence of motor
}   ;   //MotorA, MotorB, or even Motor[2];

#endif
