#include "mbed.h"
#include "DualBLS.h"
#include "BufferedSerial.h"
extern  BufferedSerial  pc;

/*class   error_handling_Jan_2019
{
    int32_t    TS_fault[NUMOF_REPORTABLE_TS_ERRORS]    ;   //  Some number of reportable error codes, accessible through set and read members
    public:
    error_handling_Jan_2019 ()  {   //  default constructor
        for (int i = 0; i < (sizeof(TS_fault) / sizeof(int32_t)); i++)
            TS_fault[i] = 0;
    }
    void        set   (uint32_t, int32_t)   ;
    uint32_t    read  (uint32_t)   ;
    bool        all_good    ()  ;
    void        report_any  ()  ;
}   ;
*/

const char * FaultList[] = {
/*
    FAULT_0,
    FAULT_EEPROM,
    FAULT_BOARD_ID,
    FAULT_COM_LINE_LEN,
    FAULT_COM_LINE_NOMATCH,
    FAULT_COM_LINE_LEN_PC,
    FAULT_COM_LINE_LEN_TS,
    FAULT_COM_LINE_NOMATCH_PC,
    FAULT_COM_LINE_NOMATCH_TS,
    FAULT_MAX,
    NUMOF_REPORTABLE_TS_ERRORS
*/
    "Zero",
    "EEPROM",
    "board ID",
    "com line len",
    "com line nomatch",
    "com line len",
    "com line len",
    "com no match",
    "com no match",
    "max",
    "endoflist",
    " ",
    }   ;

bool    error_handling_Jan_2019::all_good   ()  {
    for (int i = 0; i < NUMOF_REPORTABLE_TS_ERRORS; i++)
        if  (ESC_fault[i])
            return  false;
    return  true;
}

/**void    error_handling_Jan_2019::set  (uint32_t err_no, int32_t bits_to_set) {
    Used to set bits in error int
    Uses OR to set new bits without clearing other bits set previously
*/
void    error_handling_Jan_2019::set  (uint32_t err_no, int32_t bits_to_set) {
    if  (bits_to_set)   {
        pc.printf   ("At Error.set, err_no %d, bits %lx\r\n", err_no, bits_to_set);
        ESC_fault[err_no] |= bits_to_set;    //  Uses OR to set new bits without clearing other bits set previously
    }
}

/**void    error_handling_Jan_2019::clr  (uint32_t err_no) {
    Used to clear all bits in error int
*/
void    error_handling_Jan_2019::clr  (uint32_t err_no) {
    ESC_fault[err_no] = 0;
}

uint32_t    error_handling_Jan_2019::read (uint32_t err_no) {
    return  ESC_fault[err_no];
}

void    error_handling_Jan_2019::report_any (bool   retain)  {
    for (int i = 0; i < NUMOF_REPORTABLE_TS_ERRORS; i++)  {
        if  (ESC_fault[i])  {
            pc.printf   ("Error report, number %d, value %d, %s\r\n", i, ESC_fault[i], FaultList[i]);
            if  (!retain)
                ESC_fault[i] = 0;
        }
    }
}

