/*  mbed brushless_motor library
    Jon Freeman
    December 2018
*/
#ifndef MBED_BRUSHLESSMOTOR_H
#define MBED_BRUSHLESSMOTOR_H

#include "mbed.h"
#include "DualBLS.h"
#include "FastPWM.h"

class   brushless_motor
{
    int32_t     angle_cnt;
    uint32_t    Hall_index[2], encoder_error_cnt, motor_poles, current_sense_rs_offset;
    uint32_t    Hall_total,         //  Incremented on every Hall sensor transition
                Hall_previous,
                visible_mode, 
                inner_mode; 
    uint32_t    direction;
    int         temp_tick;
    double      RPM_filter, dv_by_dt;
    double      target_speed;
    bool        moving_flag;
    const       uint16_t * lut;
    AnalogIn    Motor_I;
    FastPWM     maxV,   maxI;
    InterruptIn H1, H2, H3;     //  Inputs for motor Hall sensors
    PortOut     OP;
    void        Hall_change ()  ;
    int         read_Halls  ()  ;           //  Returns 3 bits of latest Hall sensor outputs
    uint32_t    max_rpm ;
    double      V_clamp ;   //  Used to limit top speed
    double      numof_current_sense_rs;
public:
#ifdef  USING_DC_MOTORS
    bool    dc_motor;
#endif
    uint32_t    tickleon;
    double      Idbl;
    double      last_V, last_I;
    double      dRPM, dMPH, s[8];
//    brushless_motor   ()  {}   ;  //  can not use this with exotic elements PortOut, FastPWM etc
    brushless_motor   (PinName iadc, PinName pwv, PinName pwi, const uint16_t *, PinName h1, PinName h2, PinName h3, PortName, int, uint32_t)   ;   //  Constructor
    bool    poles       (int)   ;   //  Set number of motor poles - 4, 6, or 8
    void    set_speed   (double)    ;   //  Sets target_speed
    void    set_V_limit (double)    ;  //  Sets max motor voltage
    void    set_I_limit (double)    ;  //  Sets max motor current
    void    motor_set   ()  ;           //  Energise Port with data determined by Hall sensors
    void    direction_set   (int)  ;    //  sets 'direction' with bit pattern to eor with MOTOR_FORWARD or MOTOR_REVERSE in set_mode
    bool    set_mode    (int);          //  sets mode to MOTOR_HANDBRAKE, MOTOR_FORWARD, MOTOR_REVERSE or MOTOR_REGENBRAKE
    bool    is_moving   ()  ;           //  Returns true if one or more Hall transitions within last 31.25 milli secs
    void    speed_monitor_and_control   ()  ;  //  call this once per main loop pass (32Hz) to keep count = edges per sec
    void    high_side_off   ()  ;
//    void    low_side_on     ()  ;
    void    sniff_current   ()  ;           //  Call this every 200us to update Idbl
}   ;   //MotorA, MotorB, or even Motor[2];

#endif
