#include "mbed.h"
#ifndef MBED_JONS_RADIO_CONTROL_IN_H
#define MBED_JONS_RADIO_CONTROL_IN_H

/**class   RControl_In
    Jon Freeman
    Jan 2019

    Checks for __-__ duration 800-2200us
    Checks repetition rate in range 5-25ms
*/
class   RControl_In         //  Class to Read servo style pwm input _____-_____
{
    InterruptIn pulse_in;
    Timer   t;
    int32_t pulse_width_us, period_us, pulse_count;
    double  lost_chan_return_value;
    void    RadC_rise ();
    void    RadC_fall ();
public:
//    RControl_In   ()    ;       //  Default Constructor
    RControl_In   (PinName inp) : pulse_in(inp)   {    //  Default Constructor
        pulse_in.mode   (PullDown);
        pulse_in.rise(callback(this, &RControl_In::RadC_rise));     // Attach handler to the rising interruptIn edge
        pulse_in.fall(callback(this, &RControl_In::RadC_fall));     // Attach handler to the falling interruptIn edge
        pulse_width_us = period_us = pulse_count = 0;
        lost_chan_return_value = 0.0;
    }   ;
    bool        validate_rx ()  ;   //  Informs whether signal being rx'd
    void        reset   ()  ;
    void        set_lost_chan_return_value  (double)  ; //  set what 'normalised' returns when no signal
    uint32_t    pulsecount  ()  ;     //  will count up at frame rate when radio control all working well
    uint32_t    pulsewidth  ()  ;
    uint32_t    period      ()  ;
    double      normalised  ();   //  Returns 0.0 <= p <= 1.0 or something else when rc not active
}   ;

#endif
