#include "mbed.h"
#include "BufferedSerial.h"
#include "Radio_Control_In.h"
/**class   RControl_In
    Jon Freeman
    Jan 2019

    Checks for __-__ duration 800-2200us
    Checks repetition rate in range 5-25ms
*/
extern  BufferedSerial  pc;

//    RControl_In::RControl_In   ()   {    //  Default Constructor
//        pulse_width_us = period_us = pulse_count = 0;
//        lost_chan_return_value = 0.0;
//    }   ;
//    RControl_In::RControl_In   (PinName inp) : pulse_in(inp)   {    //  Default Constructor
//        pulse_width_us = period_us = pulse_count = 0;
//        lost_chan_return_value = 0.0;
//    }   ;
/**
*/
void        RControl_In::set_lost_chan_return_value  (double d)  {
    lost_chan_return_value = d;
}

uint32_t    RControl_In::pulsewidth   ()
{
    return  pulse_width_us;
}

uint32_t    RControl_In::pulsecount   ()
{
    return  pulse_count;
}

uint32_t    RControl_In::period   ()
{
    return  period_us;
}

void    RControl_In::reset ()
{
    pulse_width_us = period_us = pulse_count = 0;
    t.reset ();
}

bool    RControl_In::validate_rx ()
{   //  Tests for pulse width and repetition rates being believable
    return  !((period_us < 5000) || (period_us > 25000) || (pulse_width_us < 800) || (pulse_width_us > 2200));
}

double  RControl_In::normalised  ()  {
    if  (!validate_rx())    {
        pc.printf   ("Invalid RCin\r\n");
        return  lost_chan_return_value;     //  ** WHAT TO RETURN WHEN RC NOT ACTIVE ? ** This is now user settable
    }                                       //  Defaults to returning 0.0, user should call set_lost_chan_value (value) to alter
    double norm = (double) (pulse_width_us - 1000);  //  left with -200 to + 1200 allowing for some margin
    norm /= 1000.0;
    if  (norm > 1.0)
        norm = 1.0;
    if  (norm < 0.0)
        norm = 0.0;
    return  norm;
}

void    RControl_In::RadC_rise    ()     //  December 2018 - Could not make Servo port bidirectional, fix by using PC_14 and 15 as inputs
{                                   
    period_us = t.read_us    ();
    t.reset ();
    t.start ();
}

void    RControl_In::RadC_fall    ()
{
    pulse_width_us = t.read_us   ();
    pulse_count++;
}
//  end of RControl_In class
