//  Feb 2018 Now using DGD21032 mosfet drivers via 74HC00 pwm gates (low side) - GOOD, works well with auto-tickle of high side drivers

//  Jan 2019    Trying to add two Radio Control inputs on PC_14 and PC_15, previously connected to unused LF Xtal. 
//              Problem - Appears to conflict with serial port used for comms with controller
//              Earlier efforts to use 'Servo' ports as 'you choose' between I/O failed as pins not capable of use as 'InterruptIn'

//  CORRECTION  Comms problem with Touch Screen was insufficient pull-up on STM3_ESC opto. Change R12 from 1k to 470R

//                  Experiment disabling RC inputs to see if clearing serial conflict is possible


//  Port A -> MotorA, Port B -> MotorB
const   uint16_t
//  This is where port bits get assigned to motor output phase switches.
//  Phases are U, V and W.
//  Each phase uses two bits, one for the low side switch, one for the high side switch.
//MotorN_port_bits[] =  {UL, VL, WL, UH, VH, WH},   //  Order must be as shown - 3 low side switches U,V,W followed by 3 high side switches U,V,W
MotorA_port_bits[] =    {0,  6,  4,  1,  7,  8},    //  List of port A bits used to drive motor A UL, VL, WL, UH, VH, WH
MotorB_port_bits[] =    {0,  1,  2, 10, 12, 13},    //  List of port B bits used to drive motor B UL, VL, WL, UH, VH, WH
//  Using port bit info in the two lines above, the compiler sorts all this into creation of lookup table
//  to provide correct energisation sequencing as motors rotate.
//  You need concern yourself no further about any of this.


AUL = (1 << MotorA_port_bits[0]),
AVL = (1 << MotorA_port_bits[1]),   //  These are which port bits connect to which mosfet driver
AWL = (1 << MotorA_port_bits[2]),

AUH = (1 << MotorA_port_bits[3]),
AVH = (1 << MotorA_port_bits[4]),
AWH = (1 << MotorA_port_bits[5]),

AUHVL =   AUH | AVL,  //  Each of 6 possible output energisations made up of one hi and one low
AVHUL =   AVH | AUL,
AUHWL =   AUH | AWL,
AWHUL =   AWH | AUL,
AVHWL =   AVH | AWL,
AWHVL =   AWH | AVL,

KEEP_L_MASK_A   = AUL | AVL | AWL,
KEEP_H_MASK_A   = AUH | AVH | AWH,

BRA = AUL | AVL | AWL,  //  All low side switches on (and all high side off) for braking

BUL = (1 << MotorB_port_bits[0]),   //  Likewise for MotorB but different port bits on different port
BVL = (1 << MotorB_port_bits[1]),
BWL = (1 << MotorB_port_bits[2]),

BUH = (1 << MotorB_port_bits[3]),
BVH = (1 << MotorB_port_bits[4]),
BWH = (1 << MotorB_port_bits[5]),

BUHVL =   BUH | BVL,
BVHUL =   BVH | BUL,
BUHWL =   BUH | BWL,
BWHUL =   BWH | BUL,
BVHWL =   BVH | BWL,
BWHVL =   BWH | BVL,

KEEP_L_MASK_B   = BUL | BVL | BWL,
KEEP_H_MASK_B   = BUH | BVH | BWH,

BRB = BUL | BVL | BWL,

PORT_A_MASK = AUL | AVL | AWL | AUH | AVH | AWH,            //  NEW METHOD FOR DGD21032 MOSFET DRIVERS
PORT_B_MASK = BUL | BVL | BWL | BUH | BVH | BWH;

//PortOut MotA    (PortA, PORT_A_MASK);   //  Activate output ports to motor drivers
//PortOut MotB    (PortB, PORT_B_MASK);

//  Pin 1   VBAT    NET +3V3

//DigitalIn   J3         (PC_13, PullUp);//  Pin 2   Jumper pulls to GND, R floats Hi
InterruptIn   Temperature_pin   (PC_13);//  Pin 2   June 2018 - taken for temperature sensor - hard wired to T1 due to wrong thought T1 could be InterruptIn


//  Pin 3   PC14-OSC32_IN   NET O32I    Xtal chucked off these pins, now needed for RC inputs
//  Pin 4   PC15-OSC32_OUT  NET O32O
//  Pin 5   PH0-OSC_IN      NET PH1
//  Pin 6   PH1-OSC_OUT     NET PH1
//  Pin 7   NRST            NET NRST
AnalogIn    Ain_DriverPot   (PC_0); //  Pin 8   Spare Analogue in, net SAIN fitted with external pull-down
AnalogIn    Ain_SystemVolts (PC_1); //  Pin 9
#define MOT_A_I_ADC PC_2
#define MOT_B_I_ADC PC_3
//AnalogIn    Motor_A_Current (PC_2); //  Pin 10
//AnalogIn    Motor_B_Current (PC_3); //  Pin 11
//  Pin 12 VSSA/VREF-   NET GND
//  Pin 13 VDDA/VREF+   NET +3V3
//  Pin 14  Port_A AUL
//  Pin 15  Port_A AUH
//  Pins 16, 17 BufferedSerial pc
BufferedSerial  pc          (PA_2, PA_3, 2048, 4, NULL);    //  Pins 16, 17    tx, rx to pc via usb lead
//  Pin 18  VSS     NET GND
//  Pin 19  VDD     NET +3V3
//  Pin 20  Port_A AWL
//  Pin 21  DigitalOut led1(LED1);
DigitalOut  LED           (PA_5); //  Pin 21
//  Pin 22  Port_A AVL
//  Pin 23  Port_A AVH
//InterruptIn  MBH2      (PC_4); //  Pin 24
//InterruptIn  MBH3      (PC_5); //  Pin 25
#define _MBH2   PC_4
#define _MBH3   PC_5
//  Pin 26  Port_B BUL
//  Pin 27  Port_B BVL
//  Pin 28  Port_B BWL
//  Pin 29  Port_B BUH
//  Pin 30  VCAP1
//  Pin 31  VSS
//  Pin 32  VDD
//  Pin 33  Port_B BVH
//  Pin 34  Port_B BWH
DigitalOut  T4        (PB_14);    //  Pin 35
DigitalOut  T3        (PB_15);    //  Pin 36
//  BufferedSerial com2 pins 37 Tx, 38 Rx
BufferedSerial  com2          (PC_6, PC_7);    //  Pins 37, 38  tx, rx to Touch Screen Controller
#define APWMV   PC_8
#define APWMI   PC_9
//FastPWM     A_MAX_V_PWM     (PC_8, PWM_PRESECALER_DEFAULT),  //  Pin 39                  pwm3/3
//            A_MAX_I_PWM     (PC_9, PWM_PRESECALER_DEFAULT); //  pin 40, prescaler value  pwm3/4
//InterruptIn MotB_Hall   (PA_8); //  Pin 41
//  Pin 41  Port_A AWH
//  BufferedSerial com3 pins 42 Tx, 43 Rx
//InterruptIn tryseredge  (PA_9);
BufferedSerial  com3        (PA_9, PA_10);    //    Pins 42, 43  tx, rx to any aux module
//  PA_9 is Tx. I wonder, can we also use InterruptIn on this pin to generate interrupts on tx bit transitions ? Let's find out !
//  No.

//  Feb 2018 Pins 44 and 45 now liberated, could use for serial or other uses
//BufferedSerial  extra_ser   (PA_11, PA_12);    //  Pins 44, 45  tx, rx to XBee module
DigitalOut  T2  (PA_11);    //  Pin 44
// was DigitalOut  T1  (PA_12);    //  Pin 45


//InterruptIn T1  (PA_12);    //  Pin 45 now input counting pulses from LMT01 temperature sensor
//  InterruptIn DOES NOT WORK ON PA_12. Boards are being made, will have to wire link PA12 to PC13
DigitalIn   T1    (PA_12);
////InterruptIn T1  (PC_13);    //  Pin 45 now input counting pulses from LMT01 temperature sensor



//  Pin 46  SWDIO
//  Pin 47  VSS
//  Pin 48  VDD
//  Pin 49  SWCLK

//Was DigitalOut  T5  (PA_15); //  Pin 50
DigitalIn   T5  (PA_15); //  Pin 50 now fwd/rev from remote control box if fitted
#define _MAH1   PC_10   //  Pin 51
#define _MAH2   PC_11   //  Pin 52
#define _MAH3   PC_12   //  Pin 53
//InterruptIn MBH1    (PD_2);     //  Pin 54
#define _MBH1   PD_2
DigitalOut  T6      (PB_3);     //  Pin 55
#define BPWMV   PB_4
#define BPWMI   PB_5
//FastPWM     B_MAX_V_PWM     (PB_4, PWM_PRESECALER_DEFAULT),  //  Pin 56                  pwm3/3
//            B_MAX_I_PWM     (PB_5, PWM_PRESECALER_DEFAULT); //  pin 57, prescaler value  pwm3/4

//I2C i2c                     (PB_7, PB_6);   //  Pins 58, 59 For 24LC64 eeprom
#define SDA_PIN PB_7
#define SCL_PIN PB_6
//  Pin 60  BOOT0

//  Servo pins, 2 off. Configured as Input to read radio control receiver
//      ** Update December 2018 **
//  These pins can not be used as InterruptIn.
//  Can be used as outputs by 'Servo'
//  If used as servo output, code gives pin to 'Servo' - seems to work
//InterruptIn Servo1_i    (PB_8); //  Pin 61  to read output from rc rx
//InterruptIn Servo2_i    (PB_9); //  Pin 62  to read output from rc rx
//  *** NOTE *** Above InterruptIn Servo using PB pins seems not to work, probably due to other Port B pins used as PortOut (try PortInOut?)
//  Nov 2018 - Yet to try using PC14, PC15, free now as 32k768 xtal not fitted


//  Pin 63  VSS
//  Pin 64  VDD
//  SYSTEM CONSTANTS
//  December 2018   ** NEED TO PROVE SERVO OUT WORKS ** YES, DONE.
    Servo   Servo1  (PB_8)  ;
//    Servos[0] = & Servo1;
    Servo   Servo2  (PB_9)  ;
//    Servos[1] = & Servo2;

