#include "mbed.h"

#ifndef MBED_DUALBLS_H
#define MBED_DUALBLS_H

//#define USING_DC_MOTORS     //  Uncomment this to play with Dinosaur DC motors

#include "BufferedSerial.h"
const   int     MOTOR_HANDBRAKE   = 0,
                MOTOR_FORWARD     = 8,
                MOTOR_REVERSE     = 16,
                MOTOR_REGENBRAKE  = 24;

const   int     TIMEOUT_SECONDS = 2;

/*  Please Do Not Alter these */
const   int     PWM_PRESECALER_DEFAULT      = 2,
                VOLTAGE_READ_INTERVAL_US    = 50,       //  Interrupts timed every 50 micro sec, runs around loop performing 1 A-D conversion per pass
                MAIN_LOOP_REPEAT_TIME_US    = 31250,    //  31250 us, with TACHO_TAB_SIZE = 32 means tacho_ticks_per_time is tacho_ticks_per_second
                MAIN_LOOP_ITERATION_Hz      = 1000000 / MAIN_LOOP_REPEAT_TIME_US,
//                CURRENT_SAMPLES_AVERAGED    = 100,     //  Current is spikey. Reading smoothed by using average of this many latest current readings
                PWM_HZ              = 15000,    //  chosen to be above cutoff frequency of average human ear
//                PWM_HZ              = 8000,    //  chosen to be above cutoff frequency of average human ear - clearly audible annoying noise
                MAX_PWM_TICKS       = (SystemCoreClock / (PWM_HZ * PWM_PRESECALER_DEFAULT)),
                TICKLE_TIMES    =   100 ,
                WATCHDOG_RELOAD = (TIMEOUT_SECONDS * 8);    //  WatchDog counter ticked down in 8Hz loop

/*  End of Please Do Not Alter these */
const   double      PI      = 4.0 * atan(1.0),
                    TWOPI   = 8.0 * atan(1.0);

enum    {COM_SOURCES, COM1, COM2, HAND, RC_IN1, RC_IN2,THEEND}  ;

enum    {MOTADIR, MOTBDIR, MOTAPOLES, MOTBPOLES, ISHUNTA, ISHUNTB, SVO1, SVO2, RCIN1, RCIN2, 
            COMM_SRC, BOARD_ID, TOP_SPEED, WHEELDIA, MOTPIN, WHEELGEAR, 
            FUT1, FUT2, FUT3, FUT4, FUT5}  ;  //  

enum    {
    FAULT_0,
    FAULT_EEPROM,
    FAULT_BOARD_ID,
    FAULT_COM_LINE_LEN,
    FAULT_COM_LINE_NOMATCH,
    FAULT_COM_LINE_LEN_PC,
    FAULT_COM_LINE_LEN_TS,
    FAULT_COM_LINE_NOMATCH_PC,
    FAULT_COM_LINE_NOMATCH_TS,
    FAULT_UNRECOGNISED_STATE,
    FAULT_MAX,
    NUMOF_REPORTABLE_TS_ERRORS
    }  ;

class   error_handling_Jan_2019
{
    int32_t    ESC_fault[NUMOF_REPORTABLE_TS_ERRORS]    ;   //  Some number of reportable error codes, accessible through set and read members
    public:
    error_handling_Jan_2019 ()  {   //  default constructor
        for (int i = 0; i < (sizeof(ESC_fault) / sizeof(int32_t)); i++)
            ESC_fault[i] = 0;
    }
    void        set   (uint32_t, int32_t)   ;
    void        clr     (uint32_t)  ;
    uint32_t    read  (uint32_t)   ;
    bool        all_good    ()  ;
    void        report_any  (bool)  ;   //  retain ? true or false
}   ;

enum    {SOURCE_PC, SOURCE_TS}  ;
const int   BROADCAST   = '\r';
const   int MAX_PARAMS = 20;
const   int MAX_CMD_LEN = 220;

struct  parameters  {
    struct kb_command const * command_list;
    BufferedSerial * com;   //  pc or com2
    int32_t position_in_list, numof_dbls, target_unit, source, numof_menu_items;
    double  dbl[MAX_PARAMS];
    bool    respond, resp_always;
}   ;

class   cli_2019    {
    struct  kb_command const * commandlist ;
    int     clindex;
    char    cmdline[MAX_CMD_LEN + 8];
    char    * cmdline_ptr;
    parameters  a   ;
public:
    cli_2019    (BufferedSerial * comport, kb_command const * list, int list_len, int source)  {
        a.com           = comport ;
        a.command_list = commandlist  = list  ;
        a.numof_menu_items  = list_len  ;
        a.source        = source    ;
        cmdline_ptr = cmdline;
        clindex    = 0;
        if  (source == SOURCE_PC)
            a.resp_always = true;
        else
            a.resp_always = false;
    }  ;
    void    core   ()  ;
    void    test   ()  ;
}   ;

class   eeprom_settings {
    I2C i2c;
    uint32_t    errors;
    char        settings    [36];
    bool        rd_24LC64  (int start_addr, char * dest, int length)    ;
    bool        wr_24LC64  (int start_addr, char * dest, int length)    ;
    bool        set_24LC64_internal_address (int    start_addr) ;
    bool        ack_poll    ()  ;
  public:
    eeprom_settings (PinName sda, PinName scl); //  Constructor
    char        rd  (uint32_t)  ;           //  Read one setup char value from private buffer 'settings'
    bool        wr  (char, uint32_t)  ;     //  Write one setup char value to private buffer 'settings'
    bool        save    ()  ;               //  Write 'settings' buffer to EEPROM
    bool        set_defaults    ();         //  Put default settings into EEPROM and local buffer
    uint32_t    errs    ()  ;               //  Return errors
}   ;




#endif

