#ifndef MBED_GPS_MOD_H
#define MBED_GPS_MOD_H
 
#include "mbed.h"
const static double PI = 2.0 * acos(0.0),
                    deg2rad = (PI / 180.0),
                    km2miles = (39370.0/36.0/1760.0);
class gps_mod
{
    enum    {NULLST, WAITING4DOLLAR, GOTDOLLAR, GOTHDR, WAITING4CR, WAITING4LF};
    const   static  int MAXMSGLEN =  86;
//    private: by default
    bool    inmsg, newdata;
    int ch, state, i, chcnt;
    char hdracc[8], dest[6*(MAXMSGLEN + 4)],
         posfix[4],
         numofsats[4],
         latstr[16],
         longstr[16],
         altistr[16],
         speed_mphourstr[16],
         headingstr[16],
         datestr[16],
         timestr[16];
    char * destptr;
public:
//BufferedSoftSerial gps_module   (PinName _pinTx, PinName _pinRx);
    gps_mod();
    int update();
    void   tock_handler();
    char * position_fix_indicator  ();
    char * message(int);
    char * time ();
    char * date ();
    char * heading ();
    char * mph ();
    char * sat_count ();
    char * latitude();
    char * longitude();
    char * altitude();
    bool    fix_valid();
    bool    new_data();
    double mergedegmin (char *, char *);
    double lat_merged ();
    double lon_merged ();
};
 
//class Flasher {
//public:
//    Flasher(PinName pin);
//    void flash(int n);
//  
//private:  
//    DigitalOut _pin;
//};
 
#endif

