#include "mbed.h"
#include "Alternator.h"
#include "I2CEeprom.h"

const   int settings_ee_addr    = eeprom_page * eeprom_page_size;

/*struct  sldandt  {
    const uint32_t     min, max, de_fault;  //  min, max, default
    const char * txt;     //  description
    char    val;
}   ;
*/
const char tabletext[] = "User Table entry 0 to 100";
extern  const int numof_op_modes;

struct  sldandt option_list[] = {
    {0, 100, 0,     tabletext},       //  Field Current Limit User Entry Table position 0
    {0, 100, 0,     tabletext},       //  Field Current Limit User Entry Table position 1
    {0, 100, 0,     tabletext},       //  Field Current Limit User Entry Table position 2
    {0, 100, 0,     tabletext},       //  Field Current Limit User Entry Table position 3
    {0, 100, 0,     tabletext},       //  Field Current Limit User Entry Table position 4
    {0, 100, 0,     tabletext},       //  Field Current Limit User Entry Table position 5
    {0, 100, 0,     tabletext},       //  Field Current Limit User Entry Table position 6
    {0, 100, 0,     tabletext},       //  Field Current Limit User Entry Table position 7
    {0, 100, 0,     tabletext},       //  Field Current Limit User Entry Table position 8
    {0, 100, 0,     tabletext},       //  Field Current Limit User Entry Table position 9
    {0, 100, 0,     tabletext},       //  Field Current Limit User Entry Table position 10
    {0, 100, 0,     tabletext},       //  Field Current Limit User Entry Table position 11
    {0, 100, 0,     tabletext},       //  Field Current Limit User Entry Table position 12
    {0, 100, 0,     tabletext},       //  Field Current Limit User Entry Table position 13
    {0, 100, 0,     tabletext},       //  Field Current Limit User Entry Table position 14
    {0, 100, 0,     tabletext},       //  Field Current Limit User Entry Table position 15
    {0, 100, 0,     tabletext},       //  Field Current Limit User Entry Table position 16
    {0, 100, 0,     tabletext},       //  Field Current Limit User Entry Table position 17
    {0, 100, 0,     tabletext},       //  Field Current Limit User Entry Table position 18
    {0, 100, 0,     tabletext},       //  Field Current Limit User Entry Table position 19
    {0, 100, 0,     tabletext},       //  Field Current Limit User Entry Table position 20
    {0, 120, 3,     "Engine warn-up delay seconds"},
    {0, 100, 20,    "Warmup servo position percent"},
    {0, numof_op_modes - 1, 0,     "Operating Mode - 0=Engine Only test, 1=Const Voltage, 2=Var Voltage, 3=Current feedback"},
    {20, 100, 50,   "Engine speed control 'P' adjust"},
    {0, 1, 0,       "0 Servo normal, 1 reverse"},
    {0, 100, 0,     "Future 26"},
    {0, 100, 0,     "Future 27"},
    {0, 100, 0,     "Future 28"},
    {0, 100, 0,     "Future 29"},
    {0, 100, 0,     "Future 30"},
    {0, 100, 0,     "Future 31"},
}   ;

/*enum    {TABL0, TABL1, TABL2, TABL3, TABL4, TABL5, TABL6, TABL7, TABL8, TABL9, TABL10, TABL11, TABL12, TABL13, TABL14, TABL15, TABL16, 
        TABL17, TABL18, TABL19, TABL20,   
        WARM_UP_DELAY, WARMUP_SERVO_POS, OP_MODE, SPEED_CTRL_P, SERVO_DIR, FUT30, FUT31 }  ;
*/
const   int    numof_eeprom_options    = sizeof(option_list) / sizeof (struct sldandt);


//I2CEeprom eeprom  (SDA_PIN, SCL_PIN, 0xa0, eeprom_page_size, 8192, 100000);
extern  I2CEeprom eeprom;   //  (SDA_PIN, SCL_PIN, 0xa0, eeprom_page_size, 8192, 100000);

/*
class   ee_settings_2020    {
    char    new_settings[eeprom_page_size + 2];
public:
    ee_settings_2020    ()  ;   //  Constructor
    int load    ()  ;
    int save    ()  ;
    char    rd    (uint32_t   i)  ;
    bool    wr   (char c, uint32_t i)  ;           //  Write one setup char value to private buffer 'settings'
}   ;
*/
    ee_settings_2020::ee_settings_2020  ()  {
//        load    ();   //  Can't use this here, causes core dump
    }  
    
int ee_settings_2020::load    ()  {
    return  eeprom.read (settings_ee_addr, new_settings, eeprom_page_size);
}

int ee_settings_2020::save    ()  {   //  Write to eeprom only those that need changing
    int count = 0;
    char    tmp[eeprom_page_size + 2];
    int n = eeprom.read (settings_ee_addr, tmp, eeprom_page_size);
    for (int i = 0; i < eeprom_page_size; i++)  {
        if  (new_settings[i] != tmp[i]) {
            count++;
            eeprom.write    (settings_ee_addr + i, new_settings[i]);
        }
    }
    return  count;
}

char    ee_settings_2020::rd    (uint32_t   i)  {
    return  new_settings[i];
}


bool    ee_settings_2020::wr   (char c, uint32_t i)  {           //  Write one setup char value to private buffer 'settings'
    if  (i >= eeprom_page_size)
        return  false;
    new_settings[i] = c;
    return  true;
}

sldandt *    ee_settings_2020::inform (uint32_t which)  {
    if  (which >= numof_eeprom_options) 
        return  NULL;
    return &option_list[which];
}



