#include "mbed.h"
#include "Servo.h"
extern  Timer   microsecs;      //  64 bit counter, rolls over in half million years

const   uint32_t    TICKOVER_RPM    = 1500; //2500;
const   uint32_t    MIN_RPM         = 1600; //3600;
const   uint32_t    MAX_RPM         = 3600; //6500;
const   uint32_t    MAX_RPM_LIMIT   = 4000; //7500;     //  Used in building lookup table
//const   double      RPM_ERR_DENOM   = (MAX_RPM_LIMIT * 20.0);   //  Larger -> more stable, Smaller -> faster response
const   double      RPM_ERR_DENOM   = (MAX_RPM_LIMIT * 12.0);   //  Larger -> more stable, Smaller -> faster response
//const   uint32_t    RPM_DEADBAND    = (MAX_RPM_LIMIT / 125);     //  Does not attempt to correct speed errors below this
const   uint32_t    RPM_DEADBAND    = (MAX_RPM_LIMIT / 180);     //  Does not attempt to correct speed errors below this
const   uint32_t    DEBOUNCE_US     = (45000000 / MAX_RPM);

const   double      RPM_FILTER_FACTOR   = 0.25;
const   double      MIN_WORKING_THROTTLE   = 0.23;
const   double      MAX_WORKING_THROTTLE   = 0.99;
/*  Cleans magneto pulses, calculates and attempts to maintain RPM  */
class   Engine_Manager    {
    uint32_t    latest_RPM_reading, core_call_count;
    uint64_t    magt0, magt1, time_since_last_spark, new_time, last_update_time;
    double      servo_position, filtered_measured_RPM, requested_RPM;
    InterruptIn MagnetoSignal;
    DigitalOut  CleanedMagneto;
    Servo       Speed_ControlServo;
//    const uint32_t  debounce;
    void        RPM_update  ();
    void        MagRise ();
    void        MagFall ();
    void        magneto_timeoutC    ();
    bool        magneto_stretch;
    bool        running_flag;
    bool        rpm_in_run_range;
    Timeout     magneto_timoC;
//    Timer       microseconds;
  public:
    Engine_Manager    (PinName magneto_signal, PinName cleaned_output, PinName for_servo)  ;   //  
    void        Set_Speed_Lever    (double);
    bool        running ();
    void        manager_core();
    double      get_servo_position  ();
    uint32_t    RPM_latest  ();
    uint32_t    RPM_filtered();
    uint32_t    get_RPM_requested ()  ;     //  Returns latest requested RPM
    uint32_t    set_RPM_literal (uint32_t);     //  Returns latest measured RPM
    uint32_t    set_RPM_percent (uint32_t);     //  Returns latest measured RPM
    uint32_t    RPM_percent_to_actual (uint32_t);     //  Returns RPM actual calculated from percent
}   ;

