#include "mbed.h"
/**
    Functions to control alternator field
*/


/**void    set_pwm (double d)   {   Range 0.0 to 1.0
    This PWM used to limit max duty ratio of alternator field energisation.
    With R25=33k and C4=100n controlling ramp input to CS pin of MCP1630 (not MCP1630V),
    ramp terminates fet 'on' pulse after a max of approx 980 us.
    With const   int PWM_PERIOD_US = 2000    , duty ratio is thus limited to approx 50% max.
    This is about right when using 12V alternator on 24V systems
    A 1.225V reference (U7) is fed to the MCP1630 error amp which compares this to fed-back proportion of system voltage.
    This adjusts final PWM down to zero % as needed to maintain alternator output voltage.
*/

class   FieldControl    {
    uint8_t     privatemadetab[440];
    uint64_t    t_on, t_off, measured_pw_us, measured_period, rise_count, fall_count;
    uint32_t    old_percent;
    PwmOut      pwm_osc_in;     //  Controller PWM driving MCP1630
    InterruptIn V_ext;          //  Connected to MCP1630 output to MOSFET
    void        VextRise ();    //  Handles - MCP1630 has just turned mosfet on
    void        VextFall ();    //  Handles - MCP1630 has just turned mosfet off
  public:
    FieldControl  (PinName pwmoscin, PinName vext)  ;   //  Constructor
    void    set_pwm (double);   //  What it says, 0.0 to 1.0 but inverts to suit MCP1630
    void    maketable   ();
    uint32_t    set_for_speed   (uint32_t rpm);
    double  get_duty_ratio  ()  ;
}   ;

