#include "mbed.h"
#include "rtos.h"
#include "MODSERIAL.h"
#include "cnc.h"
#include <cctype>

extern  MODSERIAL pc;
extern  void    report_inputs   ()  ;

#if defined I2C_Enable
extern    I2CSlave slave;//(PTE0, PTE1); on KL25

int i2c_checksumchecker (char * buf, int len)    {
    int k, i = 0x01;
    for (k = 0; k < len; k++)
        i += buf[k];
    i &= 0x0ff;
    return  i;
}

int i2c_checksumchecker (char * buf)    {
    return  i2c_checksumchecker (buf, strlen(buf));
}

char * add_csum (char * buf, int len)    {           //  Adds checksum to end of binary string of known length
    int j;
    char    cs = 0;
    for (j = 0; j < len; j++) {
        cs += buf[j];
    }
    buf[len] = 0xff - cs;
    buf[len + 1] = 0;
    return  buf;
}

char * add_csum (char * buf)    {           //  Adds checksum to end of null terminated string
    return  add_csum    (buf, strlen(buf));
}

void    i2c_handler    (void const * name)
{
    const int i2buflen = 16;
    int err = 0;
    char    buf[i2buflen];
    char msg[20] = "Message 2snd\0";
    add_csum(msg);
    slave.address(0xc0);
    err = slave.write(msg, strlen(msg) + 1); // Includes null char    //  returns 0 on success, nz otherwise
    while   (true)  {
        int i = slave.receive();
        switch (i) {
            case I2CSlave::NoData:  //  Happens most of the time    NoData - the slave has not been addressed
                osThreadYield();  //  Using RTOS on this project
                break;
            case I2CSlave::ReadAddressed:   //   - the master has requested a read from this slave
                err = slave.write(msg, strlen(msg) + 1); // Includes null char    //  returns 0 on success, nz otherwise
                pc.printf("RdAddr'd ");
                break;
            case I2CSlave::WriteGeneral:    //   - the master is writing to all slave
                err = slave.read(buf, i2buflen);    //  returns 0 on success, nz otherwise
                pc.printf("i=%d, - the master is writing to all slave %s\r\n", i, buf);
                break;
            case I2CSlave::WriteAddressed:  //   - the master is writing to this slave
                err = slave.read(buf, i2buflen);    //  returns 0 on success, nz otherwise
                pc.printf("M wr-> [%s]", buf);
                for (int z = 0; z < strlen(buf); z++)
                    pc.printf("%2x, ", buf[z]);
                pc.printf("cs %2x\r\n", i2c_checksumchecker(buf));
                break;
            default:
                pc.printf("Unknown I2C code %d\r\n");
                break;
        }   //  end of switch (i) upon result of slave.receive()
        if  (err)   {
            pc.printf("Err %d with i = %d\r\n", err, i);
            err = 0;
        }
        memset  (buf, 0, i2buflen);    // Clear buffer
    }   //  end of while (true)
}       //  end of void    i2c_handler    (void const * name)

#endif

extern  char const *    target_str_addr (void)   ;
void    target_cmd (struct singleGparam * a)   {
    pc.printf("Computer is %s\r\n", target_str_addr());
}

//extern  void    FPGA_bit    (int whichbit, int hiorlo)    ;

extern  void    setpir_cmd  (struct singleGparam * a)  ;
extern  void    setcmd_cmd  (struct singleGparam * a)  ;
extern  void    getdro_cmd  (struct singleGparam * a)  ;
extern  void    getpir_cmd  (struct singleGparam * a)  ;
extern  void    clrpir_cmd  (struct singleGparam * a)  ;
extern  void    clrdro_cmd  (struct singleGparam * a)  ;
extern  void    setdro_cmd  (struct singleGparam * a)  ;


void    report_ins_cmd  (struct singleGparam * a)  {
   report_inputs();
}
void    menucmd (struct singleGparam * a);
struct kb_command  {
    const char * cmd_word;         //  points to text e.g. "menu"
    const char * explan;
    void (*f)(struct singleGparam *);   //  points to function
}  ;

struct  kb_command const * command_list_ptr = NULL;   //  Pointer switched between 'input_syntax_check' and 'command_execute'

struct  kb_command const  input_syntax_check  [] = {
    {"menu", "Lists available commands, same as ls", menucmd},
    {"ls", "Lists available commands, same as menu", menucmd}    
    }   ;

struct  kb_command const command_execute[] = {
    {"menu", "Lists available commands, same as ls", menucmd},
    {"ls", "Lists available commands, same as menu", menucmd},
    {"inputs", "Report State of Input bits", report_ins_cmd},
    {"pir", "Send number to FPGA pir", setpir_cmd},
    {"cmd", "Send command to FPGA command reg", setcmd_cmd},
    {"rddro", "Read DRO from FPGA", getdro_cmd},
    {"rdpir", "Read PIR from FPGA", getpir_cmd},
    {"clrpir", "Zero PIR", clrpir_cmd},
    {"clrdro", "Zero DRO", clrdro_cmd},
    {"setdro", "Set DRO", setdro_cmd},
    {"target", "Identify computer device", target_cmd},
};

int numof_menu_items;
void    menucmd (struct singleGparam * a)
{
    pc.printf("At menucmd function - listing commands:-\r\n");
    for(int i = 0; i < numof_menu_items; i++)
        pc.printf("[%s]\t\t%s\r\n", command_list_ptr[i].cmd_word, command_list_ptr[i].explan);
    pc.printf("End of List of Commands\r\n");
}

extern  void    grain_clr   (struct singleGparam & g)  ;

void    command_line_interpreter    (void const * name)
{
const int MAX_PARAMS = 10, MAX_CMD_LEN = 120;
static  char    cmd_line[MAX_CMD_LEN + 4];
static  struct  singleGparam   params[MAX_PARAMS + 1];
static  int     cl_index = 0, lastalpha = 0;
static  fl_typ  fracmul;
    if  (true)  {
        command_list_ptr = command_execute;
        numof_menu_items = sizeof(command_execute) / sizeof(kb_command);
    }
    else    {
        command_list_ptr = input_syntax_check;
        numof_menu_items = sizeof(input_syntax_check) / sizeof(kb_command);
    }
    while   (true)  {
        while  (pc.readable()) {
            int     ch;
            if  (cl_index > MAX_CMD_LEN)  {   //  trap out stupidly long command lines
                pc.printf   ("Keyboard Error!! Killing stupidly long command line");
                cl_index = 0;
            }
            ch = tolower(pc.getc());
            if  (ch == '\r' || ch >= ' ' && ch <= 'z')
                pc.printf("%c", ch);
//            else    {                   //  Using <Ctrl>+ 'F', 'B' for Y, 'L', 'R' for X, 'U', 'D' for Z
//                cl_index = 0;           //                 6    2          12   18         21   4
//                pc.printf("[%d]", ch);
//                nudger  (ch);
//            }
            if(ch != '\r')  //  was this the 'Enter' key?
                cmd_line[cl_index++] = ch;  //  added char to command being assembled
            else    {   //  key was CR, may or may not be command to lookup
                cmd_line[cl_index] = 0; //  null terminate command string
                if(cl_index)    {   //  If have got some chars to lookup
                    int i, wrdlen;
                    for (i = 0; i < numof_menu_items; i++)   {   //  Look for input match in command list
                        wrdlen = strlen(command_list_ptr[i].cmd_word);
                        if(strncmp(command_list_ptr[i].cmd_word, cmd_line, wrdlen) == 0
                            && !isalpha(cmd_line[wrdlen]))  {   //  If match found
                            bool negflag = false;
                            int state = 0, paramindex;
    //                            pc.printf("Found match for word [%s]\r\n", kbc[i].wrd);
                            for(paramindex = 0; paramindex < MAX_PARAMS; paramindex++) 
                                grain_clr   (params[paramindex]);
                            paramindex = 0;
                            //  read any parameters from command line here
                            //  Using parameters[0] as count of parameters to follow
                            while   (wrdlen <= cl_index)  {
                                ch = cmd_line[wrdlen++];
                                if(isalpha(ch)) lastalpha = ch;
                                if(ch == '-')   negflag = true;
                                if(ch == '+')   negflag = false;
                                switch  (state) {
                                    case    0:  //  looking for start of a number string
                                        if(isdigit(ch)) {   //  found first digit of a number string
                                            paramindex++;
                                            if(paramindex > MAX_PARAMS)    {
                                                wrdlen = cl_index;  //  exit condition
                                                pc.printf("WARNING - too many parameters, ignoring extra\r\n");
                                            } else    {
                                                params[paramindex].i = ch - '0';
                                                params[paramindex].c = lastalpha;
                                                state = 1;  //  Found first digit char of number string
                                            }
                                        }
                                        break;
                                    case    1:  //  looking for end of a number string
                                        if(isdigit(ch)) {   //  accumulating integer from string
                                            params[paramindex].i *= 10;
                                            params[paramindex].i += ch - '0';
                                        } else    { //  found non-digit terminating number
                                            if  (ch == '.')  {
                                                state = 2;
                                                fracmul = 0.1;
                                                params[paramindex].flt = (fl_typ)params[paramindex].i;
                                            } else    {
                                                params[0].i++;    //  count of validated parameters
                                                state = 0;  //  Have read past last digit of number string
                                                if(negflag) {
                                                    params[paramindex].i = -params[paramindex].i;
                                                    negflag = false;
                                                }
                                                params[paramindex].flt = (fl_typ)params[paramindex].i;
                                            }
                                        }
                                        break;
                                    case    2:  //  looking for fractional part of double
                                        if(isdigit(ch)) {   //  accumulating fractional part from string
                                            params[paramindex].flt += (fl_typ)((ch - '0') * fracmul);
                                            fracmul /= 10.0;
                                        } else    { //  found non-digit terminating double precision number
                                            params[0].i++;    //  count of validated parameters
                                            state = 0;  //  Have read past last digit of number string
                                            if(negflag) {
                                                params[paramindex].i = -params[paramindex].i;
                                                params[paramindex].flt = -params[paramindex].flt;
                                                negflag = false;
                                            }
                                        }
                                        break;
                                    default:
                                        break;
                                }   //  end of switch state
                            }       //  end of while wrdlen < cl_index
    //                            pc.printf("Found match to [%s] with %d parameters\r\n", command_list_ptr[i].wrd, paramindex);
                            command_list_ptr[i].f(params);   //  execute command
                            i = numof_menu_items + 1;    //  to exit for loop
                        }
                    }       // End of for numof_menu_items
                    if(i == numof_menu_items)
                        pc.printf("No Match Found for CMD [%s]\r\n", cmd_line);
                }           //  End of If have got some chars to lookup
                pc.printf("\r\n>");
                cl_index = lastalpha = 0;
            }               // End of else key was CR, may or may not be command to lookup
        }                   //  End of while (pc.readable())
        osThreadYield();  //  Using RTOS on this project
    }
}

////} cli;

