/**
Programme   COPIED FROM "cnc__machine_driver_3"
Author      Jon Freeman

Designed to compile and run on:
    Mbed LPC1768
    Freescale KL25Z
    Freescale KL46Z
*/
using namespace std;

typedef float  fl_typ;  //  
    
//#define SPI_Enable
#define I2C_Enable
#define ESTOP   0x100   //  bits used in input reading KX3 limit and EStop switches
#define XLIM    1
#define YLIM    2
#define ZLIM    4
#define UNKN    8

const   fl_typ  TWO_PI = 8.0 * atan(1.0);
const   fl_typ  epsilon = 1e-5;
struct  pirbufgrain {
    fl_typ  x,
            y,
            z,
            distance_code,
            f_rate;
    }   ;

struct  singleGparam    {   //  Place to put all we know about 'x' or 'j' etc parameter from G Code line
    fl_typ          flt;
    unsigned long   ul;
    int         i,  c;
    bool            changed;      // Flagged true when new value for this axis found in Gcode line, false otherwise 
}   ;

struct  Gparams {  //  Where possibly messy G code line gets ordered and sorted into
    struct  singleGparam   x, y, z, i, j, r, a, b, c, d;   //  After sorting, know where to find any X, Y etc values !
}   ;

const int NumofGParams = sizeof(struct Gparams) / sizeof(struct singleGparam);

#define clken       XDi
#define d_in_isr    XSt
#define d_in_osr    YDi
#define ld_osr      YSt
#define ld_pir      ZDi
#define sclk        ZSt
#define sclr        ADi

