#ifndef UDPSOCKET_H
#define UDPSOCKET_H

#include "Endpoint.h"
#include "Socket.h"

/**
UDP Socket
*/
class UDPSocket: public Socket
{

public:
    /** Instantiate an UDP Socket.
    */
    UDPSocket();

    /** Init the UDP Client Socket without binding it to any specific port
    \return 0 on success, -1 on failure.
    */
    int init(void);

    /** Bind a UDP Server Socket to a specific port
    \param port The port to listen for incoming connections on
    \return 0 on success, -1 on failure.
    */
    int bind(int port = -1);

    /** Send a packet to a remote endpoint
    \param remote   The remote endpoint
    \param packet   The packet to be sent
    \param length   The length of the packet to be sent
    \return the number of written bytes on success (>=0) or -1 on failure
    */
    int sendTo(Endpoint &remote, char *packet, int length);

    /** Receive a packet from a remote endpoint
    \param remote   The remote endpoint
    \param buffer   The buffer for storing the incoming packet data. If a packet
           is too long to fit in the supplied buffer, excess bytes are discarded
    \param length   The length of the buffer
    \return the number of received bytes on success (>=0) or -1 on failure
    */
    int receiveFrom(Endpoint &remote, char *buffer, int length);
};

#endif
