#ifndef SOCKET_H
#define SOCKET_H

#include "IPStack.h"

/** Socket file descriptor and select wrapper
  */
class Socket {
public:
    /** Socket
     */
    Socket();
    
    /** Set blocking or non-blocking mode of the socket and a timeout on
        blocking socket operations
    \param blocking  true for blocking mode, false for non-blocking mode.
    \param timeout   timeout in ms [Default: (1500)ms].
    */
    void set_blocking(bool blocking, unsigned int timeout=1500);
    
    /** Close the socket file descriptor
     */
    int close(bool shutdown = true);
    
    ~Socket();
    
protected:
    bool _blocking;
    int _timeout;
    IPStack * ip;
};


#endif /* SOCKET_H_ */
