#ifndef ENDPOINT_H
#define ENDPOINT_H

class UDPSocket;

/**
IP Endpoint (address, port)
*/
class Endpoint {
    friend class UDPSocket;

public:
    /** IP Endpoint (address, port)
     */
    Endpoint(void);
    
    ~Endpoint(void);
    
    /** Reset the address of this endpoint
     */
    void reset_address(void);
    
    /** Set the address of this endpoint
    \param host The endpoint address (it can either be an IP Address or a hostname that will be resolved with DNS).
    \param port The endpoint port
    \return 0 on success, -1 on failure (when an hostname cannot be resolved by DNS).
     */
    int  set_address(const char* host, const int port);
    
    /** Get the IP address of this endpoint
    \return The IP address of this endpoint.
     */
    char* get_address(void);
    
    /** Get the port of this endpoint
    \return The port of this endpoint
     */
    int get_port(void);

protected:
    char _ipAddress[128];
    int _port;
};

#endif
