#include "mbed.h"
#include "Adafruit_SSD1306.h"
#include "MPU9150.h"
#include "USBSerial.h"
#include "Controls.h"
#include "nRF24L01P.h"



// #define USE_USBSERIAL
// #define USE_NRF

// modified für EzSBC2

DigitalOut ledRed(P1_16);
DigitalOut ledGreen(P1_15);

float sum = 0;
uint32_t sumCount = 0;
char buffer[14];

Timer t;
#ifdef USE_USBSERIAL
USBSerial pc;
#endif


// an I2C sub-class that provides a constructed default
class I2C2 : public I2C
{
public:
    I2C2(PinName sda, PinName scl) : I2C(sda, scl) {
        frequency(400000);
        start();
    };
};

#ifdef USE_NRF
nRF24L01P my_nrf24l01p(P0_9, P0_8, P1_29, P0_11, P0_7, P0_17);    // mosi, miso, sck, csn, ce, irq
#endif

I2C2 gI2C(P0_5, P0_4);
Adafruit_SSD1306_I2c gOled2(gI2C, NC, 0x78, 64, 128);

I2Cdev  i2Cdev;
MPU9150 mpu(i2Cdev);

#define TRANSFER_SIZE   4

int main()
{
    uint16_t x=0;

    uint16_t txData[2];
    

#ifdef USE_NRF
    my_nrf24l01p.powerUp();

    // Display the (default) setup of the nRF24L01+ chip
    //pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_nrf24l01p.getRfFrequency() );
    //pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  my_nrf24l01p.getRfOutputPower() );
    //pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", my_nrf24l01p.getAirDataRate() );
    //pc.printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", my_nrf24l01p.getTxAddress() );
    //pc.printf( "nRF24L01+ RX Address   : 0x%010llX\r\n", my_nrf24l01p.getRxAddress() );

    //pc.printf( "Type keys to test transfers:\r\n  (transfers are grouped into %d characters)\r\n", TRANSFER_SIZE );

    my_nrf24l01p.setTransferSize( TRANSFER_SIZE );

    //my_nrf24l01p.setReceiveMode();
    my_nrf24l01p.setTransmitMode();
    my_nrf24l01p.enable();
#endif

    //while(1)
    {
        ledRed = 1;
        ledGreen = 0;
        wait(0.5);

        ledRed = 0;
        ledGreen = 1;
        wait(0.5);
    }

    int16_t y = 12;
    int16_t ySize = 4;
    int16_t yGap = 2;
    
    float   scaleMin = SHRT_MIN * 0.5f;     // fullscale = -1g
    float   scaleMax = SHRT_MAX * 0.5f;     // fullscale = +1g

    Canvas canvasBG(gOled2);
    barGraph bgAx(barGraph::bgHorizontal, 0, y, 127, y+ySize);
    canvasBG.addControl(bgAx);
    bgAx.setScale(scaleMin, scaleMax);
    y = y + ySize + yGap;

    barGraph bgAy(barGraph::bgHorizontal, 0, y, 127, y+ySize);
    canvasBG.addControl(bgAy);
    bgAy.setScale(scaleMin, scaleMax);
    y = y + ySize + yGap;

    barGraph bgAz(barGraph::bgHorizontal, 0, y, 127, y+ySize);
    canvasBG.addControl(bgAz);
    bgAz.setScale(scaleMin, scaleMax);
    y = y + ySize + yGap;

    barGraph bgGx(barGraph::bgHorizontal, 0, y, 127, y+ySize);
    canvasBG.addControl(bgGx);
    bgGx.setScale(scaleMin, scaleMax);
    y = y + ySize + yGap;

    barGraph bgGy(barGraph::bgHorizontal, 0, y, 127, y+ySize);
    canvasBG.addControl(bgGy);
    bgGy.setScale(scaleMin, scaleMax);
    y = y + ySize + yGap;

    barGraph bgGz(barGraph::bgHorizontal, 0, y, 127, y+ySize);
    canvasBG.addControl(bgGz);
    bgGz.setScale(scaleMin, scaleMax);

    gOled2.clearDisplay();
    gOled2.display();

    //gOled2.setTextCursor(1, 0);
    gOled2.printf("%ux%u OLED Display\r\n", gOled2.width(), gOled2.height());

#ifdef USE_USBSERIAL
    pc.printf("MPU6050 test\n\n");
    pc.printf("MPU6050 initialize \n");
#endif

    int16_t ax, ay, az;
    int16_t gx, gy, gz;

    mpu.initialize();

#ifdef USE_USBSERIAL
    pc.printf("MPU6050 testConnection \n");
#endif

    bool mpu6050TestResult = mpu.testConnection();

#ifdef USE_USBSERIAL
    if(mpu6050TestResult) {
        pc.printf("MPU6050 test passed \n");
    } else {
        pc.printf("MPU6050 test failed \n");
    }
#endif

    char buffer[32];
    while(1) {
        ledRed = !ledRed;
        gOled2.clearDisplay();

        mpu.getMotion6(&ax, &ay, &az, &gx, &gy, &gz);
        //writing current accelerometer and gyro position
        //pc.printf("%d;%d;%d;%d;%d;%d\n",ax,ay,az,gx,gy,gz);

        if (0) {
            sprintf(buffer, "%i %i %i", ax, ay, az);
        }

#ifdef USE_NRF
        // Send the transmitbuffer via the nRF24L01+
        txData[0] = ax;
        txData[1] = ay;
        my_nrf24l01p.write( NRF24L01P_PIPE_P0, (char*)txData, TRANSFER_SIZE );
#endif


        gOled2.setTextCursor(0, 0);
        //gOled2.printf("wifi ok: %u\r", wifiOk);

        bgAx.setValue(ax);
        bgAy.setValue(ay);
        bgAz.setValue(az);

        bgGx.setValue(gx);
        bgGy.setValue(gy);
        bgGz.setValue(gz);

        canvasBG.draw();

        gOled2.display();

        x++;
        //wait(0.01);
    }
}
