#include "mbed.h"
#include "Adafruit_SSD1306.h"

// Pindefinitions for ezSBC2 or LPCXpresso

// an SPI sub-class that provides a constructed default
class SPI2 : public SPI
{
public:
    SPI2(PinName mosi, PinName miso, PinName clk) : SPI(mosi, miso, clk) {
        format(8, 3);
        frequency(2000000);
    };
};

// an I2C sub-class that provides a constructed default
class I2C2 : public I2C
{
public:
    I2C2(PinName sda, PinName scl) : I2C(sda, scl) {
        frequency(400000);
        start();
    };
};

#ifdef LPC1347
// ezSBC2
DigitalOut ledRed(P1_16);
DigitalOut ledGreen(P1_15);

I2C2 gI2C(P0_5, P0_4);
Adafruit_SSD1306_I2c gOled2(gI2C, NC, 0x78, 64, 128);
#elif defined(TARGET_LPC824)
DigitalOut ledRed(LED1);
DigitalOut ledGreen(LED2);

I2C2 gI2C(SDA, SCL);
Adafruit_SSD1306_I2c gOled2(gI2C, NC, 0x78, 64, 128);
#elif defined(LPC1549)
// LPCXpresso1549
DigitalOut ledRed(LED1);
DigitalOut ledGreen(LED2);

I2C2 gI2C(SDA, SCL);
Adafruit_SSD1306_I2c gOled2(gI2C, NC, 0x78, 64, 128);
#elif defined (TARGET_LPC4088)
DigitalOut ledRed(LED1);
DigitalOut ledGreen(LED2);

I2C2 gI2C(MBED_I2C0);
Adafruit_SSD1306_I2c gOled2(gI2C, NC, 0x78, 64, 128);
#else
#error "no target defined"
#endif

int main()
{
    uint16_t x = 0;

    //while(1)
    {
        ledRed = 1;
        ledGreen = 0;
        wait(0.5);

        ledRed = 0;
        ledGreen = 1;
        wait(0.5);
    }

    gOled2.clearDisplay();
    gOled2.display();

    //gOled2.setTextCursor(1, 0);
    gOled2.printf("%ux%u OLED Display\r\n", gOled2.width(), gOled2.height());

    while (1) {
        ledRed = !ledRed;

        gOled2.setTextCursor(0, 10);
        gOled2.printf("%u\r", x);
        gOled2.display();

        x++;
        wait(1.0);
    }
}
