#include "Controls.h"

#if (USE_BARGRAPH == 1)
barGraph::barGraph(bgOrientation _orientation, int16_t _x0, int16_t _y0, int16_t _x1, int16_t _y1) :
    baseControl()
{
    orientation = _orientation;
    x0 = _x0;
    y0 = _y0;
    x1 = _x1;
    y1 = _y1;
}

void barGraph::setScale(float _valMin, float _valMax)
{
    valMin = _valMin;
    valMax = _valMax;
    if (orientation == bgHorizontal) {
        valScaleFactor = (x1 - x0) / (valMax - valMin);
        zeroPos = x0 - valScaleFactor * valMin;
    } else {
        valScaleFactor = (y1 - y0) / (valMax - valMin);
        zeroPos = y0 - valScaleFactor * valMin;
    }
}

void barGraph::setValue(float _val)
{
    val = _val;
}

void barGraph::draw(Adafruit_GFX &canvas)
{
    int16_t p;
    int16_t w;
    
    if (orientation == bgHorizontal) {
        p = x0 + valScaleFactor * (val - valMin);
        for (w = y0; w <= y1; w++)
            canvas.drawLine(zeroPos, w, p, w, WHITE);
        
    } else {
        p = y0 + valScaleFactor * (val - valMin);
        for (w = x0; w <= x1; w++)
            canvas.drawLine(zeroPos, w, p, w, WHITE);
    }
}

#endif
