#ifndef _Controls_h_
#define _Controls_h_

#include "mbed.h"
#include "SmallGUIBase.h"

#if (USE_BARGRAPH == 1)
class barGraph : public baseControl
{
    public:
    enum bgOrientation {bgHorizontal, bgVertical};
    
    barGraph(bgOrientation orientation, int16_t x0, int16_t y0, int16_t x1, int16_t y1);
    
    void setScale(float valMin, float valMax);
    void setValue(float val);
    
    virtual void draw(Adafruit_GFX &canvas);
    
    private:
    bgOrientation   orientation;
    int16_t x0;
    int16_t y0;
    int16_t x1;
    int16_t y1;
    int16_t zeroPos;
    float valMin;
    float valMax;
    float valScaleFactor;
    float val;
    
};
#endif

#endif
