#include "SmallGUIBase.h"

Canvas::Canvas(Adafruit_GFX &_gfxDevice) :
    gfxDevice(_gfxDevice)
{
    ctrlCount = 0;
}

void Canvas::draw()
{
    // call draw() on all controls
    int i;
    for (i=0; i < ctrlCount; i++)
        ctrlList[i]->draw(gfxDevice);
}

void Canvas::addControl(baseControl &bc)
{
    if (ctrlCount < MAX_CONTROLS_PER_CANVAS) {
        ctrlList[ctrlCount] = &bc;
        ctrlCount++;
    }
}