#include "mbed.h"
#include "wsDrive.h"

// time period between each movement
#define updatePeriodMS 200

// number of LEDs in chain
#define chainLen 3

// set the pulldown and then create the driver
//DigitalIn dummy(P0_15, PullDown);
//wsDrive ledDriver(P0_15, P0_7, P0_14);     // LPC812
//wsDrive ledDriver(P1_22, P0_22, P1_15);     // LPC1347
wsDrive ledDriver(P0_28, P0_12, P0_16);     // LPC1549
//wsDrive ledDriver(PB_5, PB_4, PB_3);      // STM32F03 - fails, wrong SPI clock

// mbuino stnadard definitions
//DigitalIn progMode(P0_3,PullDown); // fix the power wasted if we ever sleep.
//BusOut LEDs(LED1, LED2, LED3, LED4, LED5, LED6, LED7); // control the LEDs

//Timer updateRateTimer;

// pixel storage buffer
pixelInfo16 pixelData[chainLen];


void blankBuffer(pixelInfo *Ptr)
{
    memset( (void *)Ptr, 0, chainLen*sizeof(pixelInfo) );
}

void setPixel(unsigned int index, pixelInfo *colourToUse)
{
    if (index < chainLen) {
        pixelData[index].R = colourToUse->R;
        pixelData[index].G = colourToUse->G;
        pixelData[index].B = colourToUse->B;
    }
}

void setPixel(unsigned int index, int r, int g, int b)
{
    if (index < chainLen) {
        pixelData[index].R = r;
        pixelData[index].G = g;
        pixelData[index].B = b;
    }
}

void clearPixel(unsigned int index)
{
    if (index < chainLen) {
        pixelData[index].R = 0;
        pixelData[index].G = 0;
        pixelData[index].B = 0;
    }
}

int main ()
{
    int intensityR = 0;
    int intensityG = 85;
    int intensityB = 170;
    int dirR = 1;
    int dirG = 1;
    int dirB = 1;

    // Tell the driver where the data is stored
    ledDriver.setData(pixelData, chainLen);
   
    //updateRateTimer.start();
    while (true) {

        if (((dirR > 0) && (intensityR >= 255)) ||
                ((dirR < 0) && (intensityR <= 0)))
            dirR *= -1;
        else
            intensityR += dirR;

        if (((dirG > 0) && (intensityG >= 255)) ||
                ((dirG < 0) && (intensityG <= 0)))
            dirG *= -1;
        else
            intensityG += dirG;

        if (((dirB > 0) && (intensityB >= 255)) ||
                ((dirB < 0) && (intensityB <= 0)))
            dirB *= -1;
        else
            intensityB += dirB;


        // modify the buffer ready for the next update
        setPixel(0, intensityR, intensityG, 0);
        setPixel(1, intensityR, 0, intensityB);
        setPixel(2, 0, intensityG, intensityB);

        ledDriver.sendData(); // send the LED data

        // wait until the correct time since the last update...
        //while (updateRateTimer.read_ms() < updatePeriodMS) {
        //
        wait_ms(200);
        //updateRateTimer.reset();
    }
}
