#if (defined(TARGET_LPC81X))
#include "BurstSPI.h"

void BurstSPI::fastWrite(int data) {
    while (!(_spi.spi->STAT & (1 << 1)));

    _spi.spi->TXDAT = (data & 0xffff);
#ifndef NO_EOT_AFTER_WRITE
    // set EOT and receive ignore flag
    _spi.spi->TXDATCTL |= ((1 << 20) | (1 << 22));
#else
    // EOT Flag disables SPI and sets MOSI level high. 
    // This is bad for cases where MOSI is used to generate NRZ signals like in wsLib for WS2812 LED
    // set receive ignore flag
    _spi.spi->TXDATCTL |= (1 << 22);
#endif
}

void BurstSPI::clearRX( void ) {
    //We already set receive ignore flag, so this function is never run.
}

#endif