
 
#include "ECG_3_click.h"
 
ECG_3_click::ECG_3_click(SPI &spiBus, PinName cs):
m_spiBus(spiBus), m_cs(cs, 1)
{
    //empty block
}

ECG_3_click::~ECG_3_click()
{
    //empty block
}


void ECG_3_click::swReset(void)
{
    writeRegister(_ECG3_SW_RST_REG, _ECG3_SW_RST_CMD);
}

void ECG_3_click::fifoReset(void)
{
    writeRegister(_ECG3_FIFO_RST_REG, _ECG3_FIFO_RST_CMD);
}

void ECG_3_click::sync(void)
{
    writeRegister(_ECG3_SYNC_REG, _ECG3_SYNCH_CMD);
}

void ECG_3_click::init(void)
{
    writeRegister(_ECG3_CNFG_GEN_REG, _ECG3_FMSTR_32768HZ_ECG_512HZ | _ECG3_ECG_CHANN_EN | _ECG3_DCLOFF_EN | _ECG3_RBIAS_100M_OHM | _ECG3_RBIASP_EN | _ECG3_RBIASN_EN);
    writeRegister(_ECG3_CNFG_CAL_REG, _ECG3_VCAL_EN | _ECG3_VMODE_BIPOL | _ECG3_VMAG_500MICROV);
    writeRegister(_ECG3_CNFG_EMUX_REG, _ECG3_ECGP_EN | _ECG3_ECGN_EN | _ECG3_ECGP_CAL_VCALP | _ECG3_ECGN_CAL_VCALN);
    writeRegister(_ECG3_CNFG_ECG_REG, 0x800000 | _ECG3_DHPF_500MILIHZ | _ECG3_DLPF_40HZ);
    writeRegister(_ECG3_CNFG_RTOR1_REG, _ECG3_WNDW_12 | _ECG3_RRGAIN_AUTO_SCALE | _ECG3_RTOR_EN | _ECG3_PAVG_8 | 0x000600);
}

void ECG_3_click::getECG(uint32_t *outECG)
{
    *outECG = readRegister(_ECG3_ECG_FIFO_REG);
    *outECG >>= 6;
}

void ECG_3_click::getRTOR(uint16_t *outHR, uint16_t *outRR)
{
    
    float res;
    uint16_t resInt;

    uint32_t rtorTemp = readRegister(_ECG3_RTOR_REG);
    rtorTemp >>= 10;
    res = 60 / ((float)rtorTemp * 0.008);
    resInt = res;
    *outHR = resInt;

    resInt = (uint16_t)rtorTemp * 8;
    *outRR = resInt;
}

uint32_t ECG_3_click::readRegister(const uint8_t reg)
{
    uint32_t data = 0;
    
    m_cs = 0;
    m_spiBus.write((reg << 1) | 1);
    data |= (m_spiBus.write(0xFF) << 16);
    data |= (m_spiBus.write(0xFF) << 8);
    data |= m_spiBus.write(0xFF);
    m_cs = 1;
    
    return data;
}
  
void ECG_3_click::writeRegister(const uint8_t reg, const uint32_t data)
{
    m_cs = 0;
    m_spiBus.write(reg << 1);
    m_spiBus.write((0x00FF0000 & data) >> 16);
    m_spiBus.write((0x0000FF00 & data) >> 8);
    m_spiBus.write( 0x000000FF & data);
    m_cs = 1;
}
 