#include "mbed.h" //MbedOS 6.15
#include "NetworkInterface.h"

#define BUFFSIZE 50

#define ROUTER
#ifndef ROUTER
    #define IP          "192.168.1.1"   //Here place your Static IP of Mbed, when you want it to connect directly to PC
    #define GATEWAY     "0.0.0.0"
    #define MASK        "255.255.255.0"
#endif
#define ADDRESS         "192.168.1.10"     /*Here place IP of your PC. Run cmd.exe and write command ipconfig.
                                             If the address will be incorrect, the first message will be lost
                                             and connection will be established with first received message from opposite side.*/
#define LOCALPORT         20
#define REMOTEPORT      2000

Thread thread;
DigitalOut led1(LED1);
DigitalOut led2(LED2);

void udpEcho(){
    printf("UDP thread starting..\n");
    NetworkInterface *net = NetworkInterface::get_default_instance();
    int net_stat;
#ifndef ROUTER
    net->disconnect();
    net_stat = net->set_network((SocketAddress)IP,(SocketAddress)MASK,(SocketAddress)GATEWAY);
    printf("set IP status: %i\n",net_stat);
#endif
    net_stat = net->connect();
    printf("connect status: %i\n",net_stat);
    
    SocketAddress ip; 
    net->get_ip_address(&ip);
    const char *p_ip = ip.get_ip_address();
    printf("IP address: %s\n", p_ip ? p_ip : "None");
    SocketAddress mask;
    net->get_netmask(&mask);
    const char *p_mask = mask.get_ip_address();
    printf("Netmask: %s\n", p_mask ? p_mask : "None");
    SocketAddress gateway;
    net->get_gateway(&gateway);
    const char *p_gateway = gateway.get_ip_address();
    printf("Gateway: %s\n", p_gateway ? p_gateway : "None");

    // Check ip
    if(ip){
        UDPSocket sock; 
        sock.open(net);
        sock.bind(LOCALPORT);
        SocketAddress targetAddr(ADDRESS,REMOTEPORT); 
        printf("Listen on local port: %d and send to remote port %d\n", LOCALPORT, REMOTEPORT);
        char buffer[] = "Hello World, UDP Echo"; 
        printf("Sending message '%s' to (%s)\n",buffer,targetAddr.get_ip_address()); 
        // first message
        sock.sendto(targetAddr, buffer, sizeof(buffer));
        printf("Waiting for message...\n");
        
        SocketAddress addr;
        while(1) {
            char in_buffer[BUFFSIZE];
            int n = sock.recvfrom(&addr, &in_buffer, sizeof(in_buffer)); 
            in_buffer[n] = '\0'; 
            printf("Recieved: %s\n", in_buffer);
            char out_buffer[BUFFSIZE];
            n = sprintf(out_buffer,"Echo - %s", in_buffer);
            out_buffer[n] = '\0';
            printf("Send back: %s\n", out_buffer);
            addr.set_port(REMOTEPORT);
            sock.sendto(addr, out_buffer, sizeof(out_buffer));
            led2 =! led2;
        } 
    }else{
        printf("No IP\n");
        net->disconnect();
        printf("Thread end\n");
    }
}


int main() { 
    printf("UDP echo example\n");
    thread.start(callback(udpEcho));
    ThisThread::sleep_for(1s);
    
    while(1) {
        led1 =! led1;
        ThisThread::sleep_for(1s);
    } 
}  