#include "mbed.h" //MbedOS 5.15 on Nucleo-F767ZI
#include "NetworkInterface.h"
 
#define BUFFSIZE 50
 
#define ROUTER
#ifndef ROUTER
    #define IP          "192.168.1.1"   //Here place your Static IP of Mbed, when you want it to connect directly to PC
    #define GATEWAY     "0.0.0.0"
    #define MASK        "255.255.255.0"
#endif
#define ADDRESS         "192.168.1.10"       /*Here place IP of your PC. Run cmd.exe and write command ipconfig.
                                             If the address will be incorrect, the first message will be lost
                                             and connection will be established with first received message from opposite side.*/
#define UDPPORT           20
#define UDPREMOTEPORT   2000
#define TCPPORT           80

 
DigitalOut          led1(LED1);
DigitalOut          led2(LED2);
DigitalOut          led3(LED3);
Thread              threadUDP;
Thread              threadTCP;
Ticker              ticker;
NetworkInterface    *net = NetworkInterface::get_default_instance();
SocketAddress       ip; 
volatile bool       startFlag = false;
volatile int        dummyValue = 0;

void tickerFunc();
void taskTCP();
void taskUDP();
 
int main() { 
    printf("Example of UDP and TCP at once\n");
    int net_stat;
#ifndef ROUTER
    net->disconnect();
    net_stat = net->set_network((SocketAddress)IP,(SocketAddress)MASK,(SocketAddress)GATEWAY);
    printf("Network set IP status: %s\n", net_stat ? "Error": "OK");
#endif
printf("Connecting...");
    net_stat = net->connect();
    printf("%s\n",net_stat ? "Error": "OK");
    net->get_ip_address(&ip);
    const char *p_ip = ip.get_ip_address();
    printf("Device IP address: %s\n", p_ip ? p_ip : "None");
    if(ip){
        SocketAddress mask;
        net->get_netmask(&mask);
        const char *p_mask = mask.get_ip_address();
        printf("Netmask: %s\n", p_mask ? p_mask : "None");
        SocketAddress gateway;
        net->get_gateway(&gateway);
        const char *p_gateway = gateway.get_ip_address();
        printf("Gateway: %s\n", p_gateway ? p_gateway : "None");
        ticker.attach(&tickerFunc, 1);
        printf("Starting of TCP and UDP threads...\n");
        ThisThread::sleep_for(200);
        threadUDP.start(callback(taskUDP));
        ThisThread::sleep_for(200);
        threadTCP.start(callback(taskTCP));
        ThisThread::sleep_for(200);
    }else{
        printf("No IP\n");
        if(net != nullptr) net->disconnect();
        printf("Program End\n");
    }
    
    while(1) {
        led1 =! led1;
        ThisThread::sleep_for(1000);
    } 
}  

void tickerFunc(){    
    dummyValue = rand() % 100; //random 0-99
}

void taskTCP(){
    printf("TCP Server starting...\n");
    TCPSocket       server;
    TCPSocket       *client;
    SocketAddress   clientAddress;
    char            in_buffer[BUFFSIZE];
    const char      *selection[] = {"!stop","!start"};
    server.open(net);
    server.bind(TCPPORT);
    server.listen(1);
    printf("TCP Server bound and listening at port: %d\n", TCPPORT);
    while (1) {
        client = server.accept();
        client->getpeername(&clientAddress);
        const char *p_clientAddress = clientAddress.get_ip_address();
        printf("Client connected from IP address: %s\n", p_clientAddress ? p_clientAddress : "None");
        bool b = true;
        while (b) {
            led2 =! led2;
            int n = client->recv(in_buffer, BUFFSIZE);
            if (n == 0) {
                printf("Client disconnected\n");
                b = false;
            }else{
                in_buffer[n] = '\0';
                char *result = nullptr;
                for(int i = 0; i<2; i++){
                    result = strstr(in_buffer,selection[i]);
                    if(result != nullptr){
                        startFlag = i;
                        break;
                    }
                }
                printf("Received message from Client :'%s'\n", in_buffer);
            }
        }
        client->close();
    }
    server.close();
    printf("Thread end\n");
}
 
void taskUDP(){
    printf("UDP starting...\n");
        UDPSocket       sock; 
        SocketAddress   addr;
        SocketAddress   targetAddr(ADDRESS,UDPREMOTEPORT); 
        sock.open(net);
        sock.bind(UDPPORT);
        printf("UDP listens on the local port: %d and send to the remote port %d\n", UDPPORT, UDPREMOTEPORT);
        char buffer[BUFFSIZE]; 
        while(1){
            while(!startFlag) ThisThread::sleep_for(100);
            sprintf(buffer,"Dummy value %d\n",dummyValue);
            sock.sendto(targetAddr, buffer, sizeof(buffer));
            printf("Send back: %s", buffer);
            led3 =! led3;
            ThisThread::sleep_for(500);
        }
}