#include "mbed.h" //MbedOS 5.15
#include "NetworkInterface.h"

#define BUFFSIZE 50
 
#define ROUTER // commented = Static IP uncomented = address assigned by router
#ifndef ROUTER
    #define IP          "192.168.1.1"   //Here place your static IP of Mbed
    #define GATEWAY     "0.0.0.0"
    #define MASK        "255.255.255.0"
#endif
#define PORT            20
 
DigitalOut led1(LED1);
 
NetworkInterface *net = NetworkInterface::get_default_instance();
TCPSocket server;
TCPSocket* client;
SocketAddress clientAddress;

char   *in_buffer;
char   *out_buffer;
 
int main (void){
    printf("TCP Echo starting...\n");
    int net_stat;
#ifndef ROUTER
    net->disconnect();
    net_stat = net->set_network((SocketAddress)IP,(SocketAddress)MASK,(SocketAddress)GATEWAY);
    printf("set IP status: %i\n",net_stat);
#endif
    net_stat = net->connect();
    printf("connect status: %i\n",net_stat);
 
    SocketAddress ip; 
    net->get_ip_address(&ip);
    const char *p_ip = ip.get_ip_address();
    printf("IP address: %s and Port: %d\n", p_ip ? p_ip : "None" , PORT );
    SocketAddress mask;
    net->get_netmask(&mask);
    const char *p_mask = mask.get_ip_address();
    printf("Netmask: %s\n", p_mask ? p_mask : "None");
    SocketAddress gateway;
    net->get_gateway(&gateway);
    const char *p_gateway = gateway.get_ip_address();
    printf("Gateway: %s\n", p_gateway ? p_gateway : "None");
    
    if(ip){ 
        server.open(net);
        server.bind(PORT);
        server.listen(1);
        while (1) {
            printf("Server bound and listening\n");
            client = server.accept();
 
            client->getpeername(&clientAddress);
            const char *p_clientAddress = clientAddress.get_ip_address();
            printf("Client connected from IP address: %s\n", p_clientAddress ? p_clientAddress : "None");
            
            bool b = true;
            while (b) {
                in_buffer = new char[BUFFSIZE];
                int n = client->recv(in_buffer, BUFFSIZE);
                if (n == 0) {
                    printf("Client disconnected\n");
                    b = false;
                }else{
                    in_buffer[n] = '\0';
                    printf("Received message from Client :'%s'\n", in_buffer);
                    out_buffer = new char[BUFFSIZE];
                    n = sprintf(out_buffer,"Echo - %s", in_buffer);
                    
                    printf("Sending echo to client\n");
                    client->send(out_buffer, n);
                    led1 =! led1;
                    delete []out_buffer;
                }
                led1 =! led1;
                delete []in_buffer;
            }
            client->close();
        }
    }else{
            printf("No IP\n");
            net->disconnect();
            printf("Program end\n");
    }
}