#include "Servo.h"
#include "mbed.h"

    Servo::Servo(PinName Pin) : ServoPin(Pin) {}

    void Servo::SetPosition(int Pos) {
        Position = Pos;
    }

    void Servo::StartPulse() {
        ServoPin = 1;
        PulseStop.attach(callback(this, &Servo::EndPulse), std::chrono::microseconds(Position));
    }

    void Servo::EndPulse() {
        ServoPin = 0;
    }

    void Servo::Enable(int StartPos, int Period) {
        Position = StartPos;
        Pulse.attach(callback(this, &Servo::StartPulse), std::chrono::microseconds(Period));
    }

    void Servo::Disable() {
        Pulse.detach();
    }