#ifndef A9G_H
#define A9G_H
#define DEBUG 1
#include <stdio.h>
#include "mbed.h"

#define DEFAULT_TIMEOUT 5
#define SMS_MAX_LENGTH 16

class A9G
{
    public:
        /** Create GSM instance
        * @param tx uart transmit pin to communicate with GSM module
        * @param rx uart receive pin to communicate with GSM module
        * @param atDebug enable/disable debug output of ATCmdParser - default false
        * @param baudRate baud rate of uart communication - default 115200
        */
        A9G(PinName tx, PinName rx, bool atDebug = false, int baudRate = 115200) ;

        /** It Initializes/establish communication with module, unlock Sim card if it is necessary and wait for Network connection
        *  @param  simPin  Pin code of Sim card for its unlocking if it necessary
        *  @returns
        *      true on success,
        *      false on error
        */
        bool init(int simPin = 0);

        /** It set text mode and send specific text to specific phone number
        *  @param  *number     phone number as destination of SMS
        *  @returns *text      text to be send via SMS
        *      true on success,
        *      false on error
        */
        bool sendSMS(const char *number, const char *text);
    private:
        BufferedSerial _uart;
        ATCmdParser _module;
};
 #endif