#include "A9G.h"
#include <string>

A9G::A9G(PinName tx, PinName rx, bool atDebug, int baud):_uart(tx,rx,baud), _module(&_uart){
    _module.debug_on(atDebug);
};

bool A9G::init(int simPin){
    bool result = true;
    // power on
    for(int i=0;i<5;i++){
        _module.send("AT");
        thread_sleep_for(500);
        if(_module.recv("OK")){
            debug_if(DEBUG, "module is up!\n");
            break;
        } else {
            debug_if(DEBUG, "No communication with _module!\n");
            return false;
        }
    }
    // SIM autentication
    if(simPin != 0){
        _module.send("AT+CPIN=%d", simPin);
        if(_module.recv("OK")){
        debug_if(DEBUG, "Sim unlocked\n");
        } else {
        debug_if(DEBUG, "SIM locked!\n");
        return false;
        }
    }

    // Wait for network registration
    string network_status[] = { "not registered, not searching", 
                                "registered, home network", 
                                "not registered, but is searching", 
                                "registration denied", 
                                "unknown", 
                                "registered, roaming"};
    int state = 0;
    debug_if(DEBUG, "Connecting to network...\n");
    _module.set_timeout(10000);
    for(int i=0;i<5;i++){
        if(_module.recv("+CREG: %d",&state)){
            if(state == 1)break;
            debug_if(DEBUG, "State: %s...\n",network_status[state].c_str());
        } else {
            debug_if(DEBUG, "State: timeout\n");
        }
        thread_sleep_for(500);
    }  
    if(state == 1){
        debug_if(DEBUG, "Connected\n");
    }else{
        debug_if(DEBUG, "Connection failed!\n");
        return false;
    }
    thread_sleep_for(1000);
    _module.set_timeout(1000);    
    return true;
    }

bool A9G::sendSMS(const char *number, const char *text){
    bool result = true;
    // set mode to text mode
    int mode = 1;
    _module.send("AT+CMGF=%d", mode);
    if(_module.recv("OK")){
        debug_if(DEBUG, "Sms mode was set to %d\n", mode);
    } else {
        debug_if(DEBUG, "Set mode failed!\n");
    }

    _module.set_timeout(10000);
    _module.send("AT+CMGS=\"%s\"", number);
    if(_module.recv(">")){
        debug_if(DEBUG, "Sms mode was set to %d\n", mode); 
        _module.send("%s\n%c", text, 0x1A); 
        int id = 0;
        if(_module.recv("+CMGS: %d", &id)){
            debug_if(DEBUG, "Sms was send to %s under id: %d \n",number, id); 
        } else {
            debug_if(DEBUG, "Sms send failed\n"); 
            result = false;
        }
    } else {
        debug_if(DEBUG, "Sms send failed\n");
        result = false;
    }
    _module.set_timeout(1000);  
    return result;
}