/*MCP4801.h - Library for Microchip MCP4801 8-Bit Voltage Output Digital-to-Analog Converter with SPI Interface.*/
//http://ww1.microchip.com/downloads/en/devicedoc/22244b.pdf
#ifndef _MCP4801_H_INCLUDED
#define _MCP4801_H_INCLUDED
#include "mbed.h"

#define VREF 2.048
#define RES8BIT 256

class MCP4801{
    public:
        MCP4801(SPI &spi, PinName ssel, PinName ldacLowPin = NC,PinName shutdownLowPin = NC);
    
        //Configuration
        void setOutput_state(uint8_t state, bool soft);
        void updateOutput();
    
        //Functionality
        int setVOutput(float voltage);
    
    private:
        DigitalOut _slaveSelectLow;
        DigitalOut _shutdownLow;
        DigitalOut _ldacLow;
        SPI* _spi;
        uint8_t shutdown = 1;
};
#endif