#include "mbed.h"
#include "ECG_3_click.h"

int main(void) 
{
    DigitalOut led(LED1, 1);
    

    SPI spiBus(D4, D5, D6);
    ECG_3_click ecg3click(spiBus, D7);
    ecg3click.swReset();
    ecg3click.fifoReset();
    thread_sleep_for(100);
    ecg3click.init();

    uint32_t ecgData;
    uint16_t outHR, outRR;

    while(1)
    {
        led = !led;
        ecg3click.getECG(&ecgData);
        printf("ECG: %zu\n", ecgData);
        ecg3click.getRTOR(&outHR, &outRR );
        printf("HeardBeat: %zu, R: %zu\n", ecgData, outRR);
        thread_sleep_for(1000);
    }
}