#include "mbed.h"
#include "stm32746g_discovery_lcd.h"
#include "DS1820.h"

#define     MAX_SENSOSRS   1 

Thread thread;
volatile float       temp = 0;
 
void oneWireThread() {
    DS1820*     ds1820[MAX_SENSOSRS];
    DigitalOut  led(LED1);
    OneWire     oneWire(D8); 
    int         sensorsFound = 0;
    
    printf("OneWireThread Starting...\n");

    for (sensorsFound = 0; sensorsFound < MAX_SENSOSRS; sensorsFound++) {
        ds1820[sensorsFound] = new DS1820(&oneWire);
        if (!ds1820[sensorsFound]->begin()) {
            delete ds1820[sensorsFound];
            break;
        }
    }
 
    if(sensorsFound != 0) {
        printf("Found %d DS1820 sensors.\n", sensorsFound);
        while (1) {
            printf("----------------\r\n");
            for (int i = 0; i < sensorsFound; i++)
                ds1820[i]->startConversion();       // start temperature conversion from analog to digital
            ThisThread::sleep_for(1000);                         // let DS1820 sensors complete the temperature conversion
            for (int i = 0; i < sensorsFound; i++) {
                if (ds1820[i]->isPresent())
                    temp = ds1820[i]->read();
                    printf("temp[%d] = %3.1f%cC\r\n", i, temp, 176); // read temperature
            }
            ThisThread::sleep_for(5000);  
        }
    }else{
        printf("No DS1820 sensor found!\r\n");        
    }
}

int main()
{
    printf("Starting\n");
    thread.start(oneWireThread);
    char buffer[20]= {0};
    HAL_Delay(500);
    BSP_LCD_Init();
    BSP_LCD_LayerDefaultInit(LTDC_ACTIVE_LAYER, LCD_FB_START_ADDRESS);
    BSP_LCD_SelectLayer(LTDC_ACTIVE_LAYER);
    BSP_LCD_SetFont(&LCD_DEFAULT_FONT);
    HAL_Delay(500);

    while(1){
        BSP_LCD_Clear(LCD_COLOR_BLACK);
        BSP_LCD_SetBackColor(LCD_COLOR_BLACK);
        BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
        BSP_LCD_DisplayStringAt(0, 1, (uint8_t *)"MBED", CENTER_MODE);
        BSP_LCD_SetTextColor(LCD_COLOR_YELLOW);
        BSP_LCD_DisplayStringAt(0, 100, (uint8_t *)"DISCOVERY STM32F746NG", CENTER_MODE);
        sprintf (buffer, "temp = %3.1fC", temp);
        BSP_LCD_DisplayStringAt(20, 175, (uint8_t *)buffer, LEFT_MODE);  
        HAL_Delay(2000);//ThisThread::sleep_for(1000);  //not working
        
    }  
}