#include "mbed.h"
#define MAX 3//number of dummy messages

struct RepMsg { //Repeating message     
    CANMessage canmsg;
    int repeatTime; //ms
};
RepMsg *tempRepMsg[MAX];

Thread thread;
EventQueue e_queue;
Queue<RepMsg, MAX * 5> queue;
DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
Serial pc(USBTX, USBRX);
CAN can2(PB_8, PB_9);
CAN can1(PB_12, PB_13);

void dumy_msg (void) { //make some dummy messages
    for(int i = 0; i < MAX; i++){
        tempRepMsg[i] = new RepMsg;
        char id_temp = 0x00 + i;
        pc.printf("Msg ID 0x%02x  data: ",id_temp);
        tempRepMsg[i]->canmsg.id = id_temp;
        tempRepMsg[i]->canmsg.len = 8;
        tempRepMsg[i]->repeatTime = (i + 1) * 250; //ms
 
        for(int y = 0; y < 8; y++){
            char temp = (0x08 + i) * (y + 1) - y;
            tempRepMsg[i]->canmsg.data[y] = temp;
            pc.printf(" 0x%02x",temp);
        }
        pc.printf("\n");
    }
}

void put_into_ (RepMsg *msg) {
    queue.put(msg);
}

int main (void) {
    pc.baud(115200); 
    pc.printf("Starts example\n");
    dumy_msg();
    wait(1);
    thread.start(callback(&e_queue, &EventQueue::dispatch_forever));
    for(int i = 0; i < MAX; i++){ //it will make queue.call_every for all dummy messages
        e_queue.call_every(tempRepMsg[i]->repeatTime,put_into_, tempRepMsg[i]);
    }
    CANMessage msg;
    while(1) {
        if (queue.empty() == false) {
            osEvent evt = queue.get();
            if (evt.status == osEventMessage) {
                RepMsg *message = (RepMsg*)evt.value.p;
                CANMessage w_msg = message->canmsg;
                can1.write(w_msg);
                myled1 = !myled1;
            }
        }
        
        if(can2.read(msg)) {
            pc.printf("ID: %9x Len: %d Data: %2x %2x %2x %2x %2x %2x %2x %2x\n", msg.id, msg.len, msg.data[0], msg.data[1], msg.data[2], msg.data[3], msg.data[4], msg.data[5], msg.data[6], msg.data[07]);
            myled2 = !myled2;
        } 
    }
}