#include "mbed.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
CAN can2(PB_8, PB_9);
CAN can1(PB_12, PB_13);
EventQueue queue(32 * EVENTS_EVENT_SIZE);
Thread t;

char counter = 0;

void send() {
    printf("send()\n");
    if(can1.write(CANMessage(1337, &counter, 1))) {
        counter++;
        printf("Message sent: %d\n", counter);
        led3 = !led3;
    } 
}

int main() {

    t.start(callback(&queue, &EventQueue::dispatch_forever)); 
    queue.call_every(1000, send); 
    
    CANMessage msg;
    while(1) {
        if(can2.read(msg)) {
            printf("Message received: %d\n", msg.data[0]);
            led2 = !led2;
        } 
        wait(0.2);
        led1 = !led1;
    }
    
}
