#include "mbed.h"
#include "const.h"
#include "Robot.h"

Robot bertl;

void Bewegen()
{
    bertl.move(); 
}

void ViererLed(int value) 
{
    bertl.NibbleLeds(value);
}

void DrehLinks()
{
    bertl.TurnLeft();
}

void LedAn(int16_t led)
{
    bertl.TurnLedOn(LED_FR1);
}

void LedAus(int16_t led)
{
    bertl.TurnLedOff(LED_FR1);
}

void RotGelbBlauLed(bool rot,bool gruen, bool blau)
{
    bertl.RGBLed(rot, gruen, blau);
}

void LedBlauAus()
{
    bertl.BlueLedsOFF();
}

void LedBlauAn()
{
    bertl.BlueLedsON();
}

bool WarteBisKnopfGedruekt()
{
    return bertl.WaitUntilButtonPressed();   
}

bool VorneKlar()
{
    return bertl.FrontIsClear();
}

bool NaheBiper()
{
    return bertl.NextToABeeper();
}

bool IstKnopfGedrueckt(const int btn)
{
    return bertl.IsButtonPressed(btn);   
}


int ZurueckschickenKnopfDruecken()
{
    return bertl.ReturnButtonPressed();  
}

int main()
{
    Bewegen();
    ViererLed(4);
    DrehLinks();
    LedAn(LED_FR1);
    LedAus(LED_FR1);
    RotGelbBlauLed(1, 1, 1);
    LedBlauAus();
    LedBlauAn();
    WarteBisKnopfGedrueckt();
    VorneKlar();
    NaheBiper();
    IstKnopfGedrueckt(BT_BR);
    ZurueckschickenKnopfDruecken();
}