#include "mbed.h"
#include <string>
#include "nucleo_L432KC.h"
#include "SDFileSystem.h"
#include "BufferedSerial.h"

//SETUP
SDFileSystem sd(SPI1_MOSI, SPI1_MISO, SPI1_SCLK, SDsel, "sd");
BufferedSerial AMB(TXD1, RXD1, 512);
Serial pc(SERIAL_TX, SERIAL_RX); // TX RX
DigitalOut greenLED(LED1);
AnalogIn   uIn(Uin);
AnalogIn   uBatt(Ubatt);

float aRef = 3.33;

#include "funktions.h"  // und Prototype

int main()
{
    AMB.baud(baudRate);
    // SDcard Test
    pc.printf("\nWait for new connection...\n");

    mkdir("/sd/mydir2", 0777);
    pc.printf("\nDirectory created\n");
    FILE *fp = fopen("/sd/mydir2/test.txt", "w"); //write
    if(fp == NULL) {
        pc.printf("Could not open file for write\n");
    }
    fprintf(fp, "Messwerte\n");
    fclose(fp);
    pc.printf("Text written to the SD-CARD\n");



    while(1) {

        while (AMB.readable()) {
            //rxflag = true;
            char r = AMB.getc();
            pc.putc(r);
        }
        pc.printf("\n");

        wait(2);

        // TX Test
        //string sendText = "Hello World!"); // UBatt ist %f Volt", uBatt.read()*aRef*2;
        sendData("Hello World! ");
        //sendData ("%f ", uBatt.read()*aRef*2);
        // LED Test
        greenLED = !greenLED;

        // interne ADC test
        pc.printf("Input: %f Volt ", uIn.read()*aRef*12);
        pc.printf("Akku : %f Volt ", uBatt.read()*aRef*2);

//
        FILE *fp = fopen("/sd/mydir2/test.txt", "a"); //append
        if(fp == NULL) {
            pc.printf("Could not open file for append data\n");
        }
        fprintf(fp, "Uin %f;uBatt %f \n", uIn.read()*aRef*12, uBatt.read()*aRef*2);
        fclose(fp);

        pc.printf("\n");
    }
}
