#include "mbed.h"


DigitalOut myled(PC_0);
DigitalOut PC1(PC_1);

void EX1IRQhandler(void)
{
    //PC1=!PC1;
    GPIOC->ODR=~GPIOC->ODR;
    EXTI->PR=0b10;
    HAL_NVIC_ClearPendingIRQ(EXTI1_IRQn);
}

//TIM_HandleTypeDef htim6;
void TIM6_IRQHandler(void)
{
    myled=!myled;
    TIM6->SR=0;
    HAL_NVIC_ClearPendingIRQ(TIM6_IRQn);
}

void EX1init(void)
{
RCC->AHBENR|=0b111;
GPIOA->PUPDR|=0b1000;
EXTI->IMR|=0b10;   
EXTI->RTSR|=0b10; 
}

static void NVIC_Init(void)
{
    /* TIM6_IRQn interrupt configuration */
    //HAL_NVIC_SetPriority(TIM6_IRQn, 0, 0);
    NVIC_SetVector(TIM6_IRQn, (uint32_t)&TIM6_IRQHandler);
    HAL_NVIC_EnableIRQ(TIM6_IRQn);
    NVIC_SetVector(EXTI1_IRQn, (uint32_t)&EX1IRQhandler);
    HAL_NVIC_EnableIRQ(EXTI1_IRQn);
}

/* TIM6 init function */
static void TIM6_Init(void)
{
    /*
    __TIM6_CLK_ENABLE();
    htim6.Instance = TIM6;
    htim6.Init.Prescaler = 3200;
    htim6.Init.CounterMode = TIM_COUNTERMODE_UP;
    htim6.Init.Period = 5000;
    if (HAL_TIM_Base_Init(&htim6) != HAL_OK) {
        while(1) {
        }
    }
    HAL_TIM_Base_Start_IT(&htim6);
    */

    RCC->APB1ENR|=0b10000;  //Clock Enable
    TIM6->PSC=3200;         //Prescaler 100µs
    TIM6->ARR=5000;         //Autoreload 5000*100µs = 0,5s
    TIM6->DIER=1;           //UIE = 1 (Update Interrupt Enable)
    TIM6->SR=0;             //UIF =0 (Update Interrupt Flag)
    TIM6->CR1=1;            //CEN=1 (Counter Enable)
}

int main()
{
    TIM6_Init();
    EX1init();
    NVIC_Init();
    while(1) {
        /*
        if (TIM6->SR==1)
        {
            TIM6->SR=0;
            myled=!myled;
        }
        */
    }

}