/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "platform/mbed_thread.h"

InterruptIn links(PA_1);
InterruptIn rechts(PA_6);
InterruptIn stop(PA_10);
DigitalIn s(PB_0);
PortOut Motor(PortC,0b11);
#define Rechts 0b10
#define Links 0b01
#define Aus 0b00

void linksISR()
{
    Motor=Links;
    rechts.disable_irq();
}
void rechtsISR()
{
    Motor=Rechts;
    links.disable_irq();  
}
void stopISR()
{
    Motor=Aus;
    rechts.enable_irq();
    links.enable_irq();
}

int main()
{
    Motor=Aus;
    links.mode(PullDown);
    rechts.mode(PullDown);
    stop.mode(PullDown);
    s.mode(PullDown);
    links.fall(&linksISR);
    rechts.fall(&rechtsISR);
    stop.fall(&stopISR);
    links.enable_irq();
    rechts.enable_irq();
    stop.enable_irq();
    __enable_irq();
    while (true) {
        if(s==1)
        {
           Motor=Aus;
           __disable_irq(); 
        }
        else
        {
            __enable_irq();
        }
    }
}
