#include "mbed.h"
//成功バージョン
Serial twe(p9, p10); // tx, rx
Serial pc(USBTX,USBRX);
DigitalOut myled(LED1);

#define DATA_SIZE 11

InterruptIn rpmcount(p17);  //回転数用のフォトインタラプタ読み取り

int rpm=0;
int rpmcounter = 0;
double time_s = 0,time_ms=0;
Ticker ticker;//updateのタイマー割り込み

//int rpm=60;
struct{
    char highbyte;
    char lowbyte;
    short intdat;
    }data;

 char s[11] ;//this can take up to 10 byte characters

Timer t,t1;

void rpm_c();
void rpm_f();
void update();
void rpm_t();

void rpm_c()  //回転数のフォトインタラプタ
{
    rpmcounter++;
}

void rpm_f()  //回転数計測
{
    
    rpm = (int)(rpmcounter * 60000/time_ms/48);
    
    rpmcounter = 0;
} 
 
 
void rpm_t(){
        /*:は送信時に必要なヘッダー。78は相手のID(0x78)。01は送信コマンドとして必要。
                  39は任意の値。Xはチェックサムの省略形。 \r\nは改行コマンド*/
                rpm+=1000;
                sprintf(s, ":7801%dX\r\n",rpm);
                /*配列sにまとめて代入。*/
                 for (int  i = 0 ; i < DATA_SIZE ; i++){  
                      twe.putc(s[i]);
                     } 
                     /*DATESIZEはこの場合11*/
                     rpm=0;
                     
                     }
 
 void update(){
     
     
     time_ms = t1.read_ms();//周期時間読み取り
    t1.stop();
    t1.reset();
    rpm_f();
    rpm_t();
    t1.start();
    
    myled = !myled;
     
 }
 
int main() {
       twe.baud(115200);
       pc.baud(115200);
       t1.start();
       
       //=============-interruptInの信号の読み取り(回転数計)==============//
       rpmcount.rise(&rpm_c);
       //===============================================================================//
        
       ticker.attach(&update,1);//1秒ごとに更新関数の発動
    
    }
    
    
    
    

