#include "mbed.h"

#define GYRO_ADDRESS 0x69
#define ACC_ADDRESS 0x19
#define MAG_ADDRESS 0x13

#define PRES_ADDRESS 0x76

#define MAG_SOFT_RESET 0x4B
#define MAG_ENEBLE 0x4E

#define GYRO_X_L 0x04
#define GYRO_X_H 0x05
#define GYRO_Y_L 0x02
#define GYRO_Y_H 0x03
#define GYRO_Z_L 0x06
#define GYRO_Z_H 0x07

#define ACC_X_L 0x04
#define ACC_X_H 0x05
#define ACC_Y_L 0x02
#define ACC_Y_H 0x03
#define ACC_Z_L 0x06
#define ACC_Z_H 0x07

#define MAG_X_L 0x42
#define MAG_X_H 0x43
#define MAG_Y_L 0x44
#define MAG_Y_H 0x45
#define MAG_Z_L 0x46
#define MAG_Z_H 0x47


#define GYRO_RANGE_SET 0x0f
#define ACC_RANGE_SET 0x0f


#define CTRL_HUM 0xf2
#define CTRL_MEAS 0xf4
#define CONFIG 0xf5

#define DIG_T1_LOW_REGS 0x88 // read dig_T1 regs
#define DIG_T1_HIGH_REGS 0x89 // read dig_T1 regs
#define DIG_T2_LOW_REGS 0x8a // read dig_T2 regs
#define DIG_T2_HIGH_REGS 0x8b // read dig_T2 regs
#define DIG_T3_LOW_REGS 0x8c // read dig_T3 regs
#define DIG_T3_HIGH_REGS 0x8d // read dig_T3 regs

#define DIG_P1_LOW_REGS 0x8e // read dig_P1 regs
#define DIG_P1_HIGH_REGS 0x8f // read dig_P1 regs
#define DIG_P2_LOW_REGS 0x90 // read dig_P2 regs
#define DIG_P2_HIGH_REGS 0x91 // read dig_P2 regs
#define DIG_P3_LOW_REGS 0x92 // read dig_P3 regs
#define DIG_P3_HIGH_REGS 0x93 // read dig_P3 regs
#define DIG_P4_LOW_REGS 0x94 // read dig_P4 regs
#define DIG_P4_HIGH_REGS 0x95 // read dig_P4 regs
#define DIG_P5_LOW_REGS 0x96 // read dig_P5 regs
#define DIG_P5_HIGH_REGS 0x97 // read dig_P5 regs
#define DIG_P6_LOW_REGS 0x98 // read dig_P6 regs
#define DIG_P6_HIGH_REGS 0x99 // read dig_P6 regs
#define DIG_P7_LOW_REGS 0x9a // read dig_P7 regs
#define DIG_P7_HIGH_REGS 0x9b // read dig_P7 regs
#define DIG_P8_LOW_REGS 0x9c // read dig_P8 regs
#define DIG_P8_HIGH_REGS 0x9d // read dig_P8 regs
#define DIG_P9_LOW_REGS 0x9e // read dig_P9 regs
#define DIG_P9_HIGH_REGS 0x9f // read dig_P9 regs

#define HUD_H1_REGS 0xA1 // read dig_H1 regs
#define HUD_H2_LOW_REGS 0xe1 // read dig_H2 regs
#define HUD_H2_HIGH_REGS 0xe2 // read dig_H2 regs
#define HUD_H3_REGS 0xe3 // read dig_H3 regs
#define HUD_H4_LOW_REGS 0xe5 // read dig_H4 regs  and HIGh of H5
#define HUD_H4_HIGH_REGS 0xe4 // read dig_H4 regs
#define HUD_H5_HIGH_REGS 0xe6 // read dig_H5 regs
#define HUD_H6_REGS 0xe7 // read dig_H6 regs

#define TEMP_MSB 0xFa
#define TEMP_LSB 0xFb
#define TEMP_XLSB 0xFc

#define PRES_MSB 0xF7
#define PRES_LSB 0xF8
#define PRES_XLSB 0xF9

#define HUM_MSB 0xFd
#define HUM_LSB 0xFe

class test_BMX055
{
public:
/*
test_BMX055::test_BMX055(PinName sda,PinName scl, char slave_adr):i2c(sda ,scl),address(slave_adr){
*/
    //test_BMX055(PinName sda,PinName scl, char slave_adr);
    //~test_BMX055();

    test_BMX055(I2C &i2c_obj, char slave_adr);
    ~test_BMX055();
            
    void i2c_mem_write(int device_address, int mem_address, int mem_data);
    int i2c_mem_read(int device_address, int mem_address);
    
    void set_gyro_range(int range);
    void set_acc_range(int range);
    
    void reset_mag();
    void initiate_mag();
    
    float get_gyro_x_data(void);
    float get_gyro_y_data(void);
    float get_gyro_z_data(void);

    float get_acc_x_data(void);
    float get_acc_y_data(void);
    float get_acc_z_data(void);
    
    float get_mag_x_data(void);
    float get_mag_y_data(void);
    float get_mag_z_data(void);
    
    
    //void initiate_pres(void);
    void initialize(void);
    /** Read the current temperature value (degree Celsius) from BME280 sensor
     *
     */
    float getTemperature(void);

    /** Read the current pressure value (hectopascal)from BME280 sensor
     *
     */
    float getPressure(void);

    /** Read the current humidity value (humidity %) from BME280 sensor
     *
     */
    float getHumidity(void);
    
    
private:

    //I2C     i2c;
    int     currentAcceleroRange;
    int     currentGyroRange;
    float   gyro_scale_factor;
    int     acc_scale_factor;
    float   gravity;
    float   RAD_TO_DEG;
    
    I2C         *i2c_p;
    I2C         &i2c;
    
    char        address;
    uint16_t    dig_T1;
    int16_t     dig_T2, dig_T3;
    uint16_t    dig_P1;
    int16_t     dig_P2, dig_P3, dig_P4, dig_P5, dig_P6, dig_P7, dig_P8, dig_P9;
    uint16_t    dig_H1, dig_H3;
    int16_t     dig_H2, dig_H4, dig_H5, dig_H6;
    int32_t     t_fine;
    

};