#include "mbed.h"
#include "test_BMX055.h"

/*
test_BMX055::test_BMX055(PinName sda,PinName scl, char slave_adr):i2c(sda ,scl),address(slave_adr),t_fine(0){
    
    //I2C initialization
    i2c.frequency(100000); //100 kHz
    
    currentGyroRange = 0;
    currentAcceleroRange=0;
    gravity=9.80665;
    RAD_TO_DEG=57.3;
}
*/
//BME280::BME280(I2C &i2c_obj, char slave_adr)

test_BMX055::test_BMX055(I2C &i2c_obj, char slave_adr):i2c(i2c_obj),address(slave_adr),t_fine(0){
    
    //I2C initialization
    i2c.frequency(100000); //100 kHz
    
    currentGyroRange = 0;
    currentAcceleroRange=0;
    gravity=9.80665;
    RAD_TO_DEG=57.3;
}


test_BMX055::~test_BMX055(){
    }

void test_BMX055::i2c_mem_write(int device_address, int mem_address, int mem_data){
    
    int device_address_temp = device_address<<1;
    device_address_temp = device_address_temp & 0xfe;

    i2c.start();
    i2c.write(device_address_temp);
    i2c.write(mem_address);
    i2c.write(mem_data); 
    i2c.stop();   
    return;
    
    }

//i2c read function
int test_BMX055::i2c_mem_read(int device_address, int mem_address)
{   
    int device_address_temp = device_address<<1;
    int device_address_temp_w = device_address_temp & 0xfe; 
    int device_address_temp_r = device_address_temp | 0x01;

    i2c.start();
    i2c.write(device_address_temp_w);
    i2c.write(mem_address);  
    i2c.start();
    i2c.write(device_address_temp_r);    
    int data = i2c.read(0);
    i2c.stop();   
    return data;
}

void test_BMX055::test_BMX055::set_gyro_range(int range){
    
    currentGyroRange=range;
    
    if(range==0){
        i2c_mem_write(GYRO_ADDRESS, GYRO_RANGE_SET, 0x00);
        gyro_scale_factor=0.061f;
    }else if(range==1){
        i2c_mem_write(GYRO_ADDRESS, GYRO_RANGE_SET, 0x01);
        gyro_scale_factor=0.0305f;
    }else if(range==2){
        i2c_mem_write(GYRO_ADDRESS, GYRO_RANGE_SET, 0x02);
        gyro_scale_factor=0.0153f;
    }else if(range==3){
        i2c_mem_write(GYRO_ADDRESS, GYRO_RANGE_SET, 0x03);
        gyro_scale_factor=0.0076f;
    }else if(range==4){
        i2c_mem_write(GYRO_ADDRESS, GYRO_RANGE_SET, 0x04);
        gyro_scale_factor=0.0038f;
    }else{}
 
    }
    
float test_BMX055::get_gyro_x_data()
{
    float x_rate;
    
    //read RATE_X_LSB registor (0x02)
    int x_temp_L = i2c_mem_read(GYRO_ADDRESS, GYRO_X_L);
    //read RATE_X_MSB registor
    int x_temp_H = i2c_mem_read(GYRO_ADDRESS, GYRO_X_H);
    
    //calculate X angular ratio
    int x_data = x_temp_L + 256 * x_temp_H;
    if(x_data > 32767)
    {
        x_data = -1 * (65536 - x_data);    
    }
    
    x_rate=(float(x_data) * gyro_scale_factor)/RAD_TO_DEG; // rad/sec
    
    return x_rate;
}

    
float test_BMX055::get_gyro_y_data()
{
    float y_rate;
    
    //read RATE_Y_LSB registor (0x04)
    int y_temp_L = i2c_mem_read(GYRO_ADDRESS, GYRO_Y_L);
    //read RATE_Y_MSB registor
    int y_temp_H = i2c_mem_read(GYRO_ADDRESS, GYRO_Y_H);
    
    //calculate Y angular ratio
    int y_data = y_temp_L + 256 * y_temp_H;
    if(y_data > 32767)
    {
        y_data = -1 * (65536 - y_data);    
    }

    y_rate=(float(y_data) * gyro_scale_factor)/RAD_TO_DEG; //  rad/sec
    
    return y_rate;
}

float test_BMX055::get_gyro_z_data()
{
    float z_rate;
    
    //read RATE_Z_LSB registor (0x04)
    int z_temp_L = i2c_mem_read(GYRO_ADDRESS, GYRO_Z_L);
    //read RATE_Z_MSB registor
    int z_temp_H = i2c_mem_read(GYRO_ADDRESS, GYRO_Z_H);
    
    //calculate Z angular ratio
    int z_data = z_temp_L + 256 * z_temp_H;
    if(z_data > 32767)
    {
        z_data = -1 * (65536 - z_data);    
    }

    z_data = -1 * z_data;

    z_rate=(float(z_data) * gyro_scale_factor)/RAD_TO_DEG; //  rad/sec
    
    return z_rate;
}

void test_BMX055::test_BMX055::set_acc_range(int range){
    
    currentAcceleroRange=range;
    
    if(range==0){// +-2G
        i2c_mem_write(ACC_ADDRESS, ACC_RANGE_SET, 0x03);
        acc_scale_factor=1024;
    }else if(range==1){//+-4G
        i2c_mem_write(ACC_ADDRESS, ACC_RANGE_SET, 0x05);
        acc_scale_factor=512;
    }else if(range==2){
        i2c_mem_write(ACC_ADDRESS, ACC_RANGE_SET, 0x08);
        acc_scale_factor=256;
    }else if(range==3){
        i2c_mem_write(ACC_ADDRESS, ACC_RANGE_SET, 0x0c);
        acc_scale_factor=128;
    }else{}
 
}

float test_BMX055::get_acc_x_data()
{
    float x_acc;
    
    //read ACC_X_LSB registor (0x02)
    int x_temp_L = i2c_mem_read(ACC_ADDRESS, ACC_X_L);
    x_temp_L = x_temp_L >> 4;
    x_temp_L = x_temp_L & 0x0f;
    
    //read ACC_X_MSB registor (0x03)
    int x_temp_H = i2c_mem_read(ACC_ADDRESS, ACC_X_H);
    
    //calculate Z acceleration
    int x_data = x_temp_L + 16 * x_temp_H;
    if(x_data > 2047)
    {
        x_data = -1 * (4096 - x_data);    
    }
    
    x_acc=float(x_data)*gravity/acc_scale_factor;//m/s^2
    
    return x_acc;
}

float test_BMX055::get_acc_y_data()
{
    float y_acc;
    
    //read ACC_X_LSB registor (0x04)
    int y_temp_L = i2c_mem_read(ACC_ADDRESS, ACC_Y_L);
    y_temp_L = y_temp_L >> 4;
    y_temp_L = y_temp_L & 0x0f;
    
    //read ACC_X_MSB registor (0x05)
    int y_temp_H = i2c_mem_read(ACC_ADDRESS, ACC_Y_H);
    
    //calculate Z acceleration
    int y_data = y_temp_L + 16 * y_temp_H;
    if(y_data > 2047)
    {
        y_data = -1 * (4096 - y_data);    
    }
    
    y_acc=float(y_data)*gravity/acc_scale_factor;//m/s^2
    
    return y_acc;
}
    
float test_BMX055::get_acc_z_data()
{
    float z_acc;
    
    //read ACC_Z_LSB registor (0x06)
    int z_temp_L = i2c_mem_read(ACC_ADDRESS, ACC_Z_L);
    z_temp_L = z_temp_L >> 4;
    z_temp_L = z_temp_L & 0x0f;
    
    //read ACC_Z_MSB registor (0x07)
    int z_temp_H = i2c_mem_read(ACC_ADDRESS, ACC_Z_H);
    
    //calculate Z acceleration
    int z_data = z_temp_L + 16 * z_temp_H;
    if(z_data > 2047)
    {
        z_data = -1*(4096 - z_data);    
    }
    
    z_acc=float(-z_data)*gravity/acc_scale_factor;//m/s^2
    
    return z_acc;
}

void test_BMX055::initiate_mag()
{
    i2c_mem_write(MAG_ADDRESS, 0x4b, 0x83);
    wait_us(10000);
    i2c_mem_write(MAG_ADDRESS, 0x4b, 0x01);
    wait_us(10000);
    i2c_mem_write(MAG_ADDRESS, 0x4c, 0x00);
    wait_us(10000);
    i2c_mem_write(MAG_ADDRESS, 0x4c, 0x00);
    wait_us(10000);
    i2c_mem_write(MAG_ADDRESS, 0x4e, 0x84);
    wait_us(10000); 
    i2c_mem_write(MAG_ADDRESS, 0x51, 0x04);
    wait_us(10000);
    i2c_mem_write(MAG_ADDRESS, 0x52, 0x16);
    wait_us(10000);
    
        
    
}

float test_BMX055::get_mag_x_data()
{
    float x_mag;
    
    //read MAG_X_LSB registor (0x42)
    int x_temp_L = i2c_mem_read(MAG_ADDRESS, MAG_X_L);
    x_temp_L = x_temp_L >> 3;
    x_temp_L = x_temp_L & 0x0f;
    
    //read MAG_X_MSB registor (0x43)
    int x_temp_H = i2c_mem_read(MAG_ADDRESS, MAG_X_H);
    
    //calculate Z acceleration
    int x_data = x_temp_L +  32* x_temp_H;
    if(x_data > 4095)
    {
        x_data = -1 * (8192 - x_data);    
    }
    
    x_mag=float(x_data);
    
    return x_mag;
    
}

float test_BMX055::get_mag_y_data()
{
    float y_mag;
    
    //read MAG_Y_LSB registor (0x44)
    int y_temp_L = i2c_mem_read(MAG_ADDRESS, MAG_Y_L);
    y_temp_L = y_temp_L >> 3;
    y_temp_L = y_temp_L & 0x0f;
    
    //read MAG_Y_MSB registor (0x45)
    int y_temp_H = i2c_mem_read(MAG_ADDRESS, MAG_Y_H);
    
    //calculate Z acceleration
    int y_data = y_temp_L +  32* y_temp_H;
    if(y_data > 4095)
    {
        y_data = -1 * (8192 - y_data);    
    }
    
    y_mag= - 1 * float(y_data);
    
    return y_mag;
    
}

float test_BMX055::get_mag_z_data()
{
    float z_mag;
    
    //read MAG_Z_LSB registor (0x46)
    int z_temp_L = i2c_mem_read(MAG_ADDRESS, MAG_Z_L);
    z_temp_L = z_temp_L >> 1;
    z_temp_L = z_temp_L & 0x0f;
    
    //read MAG_Z_MSB registor (0x47)
    int z_temp_H = i2c_mem_read(MAG_ADDRESS, MAG_Z_H);
    
    //calculate Z acceleration
    int z_data = z_temp_L +  128* z_temp_H;
    if(z_data > 16383)
    {
        z_data = -1 * (32768 - z_data);    
    }
    
    z_mag= - 1* float(z_data);
    
    return z_mag;
    
}

//Pressure sensor BME280

void test_BMX055::initialize()
{
    //I2C initialization
    //i2c.frequency(400000); //400 kHz
    //i2c.frequency(100000); //100 kHz
    
    char cmd[18];
 
    cmd[0] = 0xf2; // ctrl_hum
    cmd[1] = 0x01; // Humidity oversampling x1
    i2c.write(address, cmd, 2);
 
    cmd[0] = 0xf4; // ctrl_meas
    cmd[1] = 0x27; // Temparature oversampling x1, Pressure oversampling x1, Normal mode
    i2c.write(address, cmd, 2);
 
    cmd[0] = 0xf5; // config
    cmd[1] = 0xa0; // Standby 1000ms, Filter off
    i2c.write(address, cmd, 2);
 
    cmd[0] = 0x88; // read dig_T regs
    i2c.write(address, cmd, 1);
    i2c.read(address, cmd, 6);
 
    dig_T1 = (cmd[1] << 8) | cmd[0];
    dig_T2 = (cmd[3] << 8) | cmd[2];
    dig_T3 = (cmd[5] << 8) | cmd[4];
 
    //DEBUG_PRINT("dig_T = 0x%x, 0x%x, 0x%x\n", dig_T1, dig_T2, dig_T3);
 
    cmd[0] = 0x8E; // read dig_P regs
    i2c.write(address, cmd, 1);
    i2c.read(address, cmd, 18);
 
    dig_P1 = (cmd[ 1] << 8) | cmd[ 0];
    dig_P2 = (cmd[ 3] << 8) | cmd[ 2];
    dig_P3 = (cmd[ 5] << 8) | cmd[ 4];
    dig_P4 = (cmd[ 7] << 8) | cmd[ 6];
    dig_P5 = (cmd[ 9] << 8) | cmd[ 8];
    dig_P6 = (cmd[11] << 8) | cmd[10];
    dig_P7 = (cmd[13] << 8) | cmd[12];
    dig_P8 = (cmd[15] << 8) | cmd[14];
    dig_P9 = (cmd[17] << 8) | cmd[16];
 
    //DEBUG_PRINT("dig_P = 0x%x, 0x%x, 0x%x, 0x%x, 0x%x, 0x%x, 0x%x, 0x%x, 0x%x\n", dig_P1, dig_P2, dig_P3, dig_P4, dig_P5, dig_P6, dig_P7, dig_P8, dig_P9);
 
    cmd[0] = 0xA1; // read dig_H regs
    i2c.write(address, cmd, 1);
    i2c.read(address, cmd, 1);
     cmd[1] = 0xE1; // read dig_H regs
    i2c.write(address, &cmd[1], 1);
    i2c.read(address, &cmd[1], 7);

    dig_H1 = cmd[0];
    dig_H2 = (cmd[2] << 8) | cmd[1];
    dig_H3 = cmd[3];
    dig_H4 = (cmd[4] << 4) | (cmd[5] & 0x0f);
    dig_H5 = (cmd[6] << 4) | ((cmd[5]>>4) & 0x0f);
    dig_H6 = cmd[7];
 
    //DEBUG_PRINT("dig_H = 0x%x, 0x%x, 0x%x, 0x%x, 0x%x, 0x%x\n", dig_H1, dig_H2, dig_H3, dig_H4, dig_H5, dig_H6);
}

float test_BMX055::getTemperature()
{
    uint32_t temp_raw;
    float tempf;
    char cmd[4];
 
    cmd[0] = 0xfa; // temp_msb
    i2c.write(address, cmd, 1);
    i2c.read(address, &cmd[1], 3);
 
    temp_raw = (cmd[1] << 12) | (cmd[2] << 4) | (cmd[3] >> 4);
 
    int32_t temp;
 
    temp =
        (((((temp_raw >> 3) - (dig_T1 << 1))) * dig_T2) >> 11) +
        ((((((temp_raw >> 4) - dig_T1) * ((temp_raw >> 4) - dig_T1)) >> 12) * dig_T3) >> 14);
 
    t_fine = temp;
    temp = (temp * 5 + 128) >> 8;
    tempf = (float)temp;
 
    return (tempf/100.0f);
}
 
float test_BMX055::getPressure()
{
    uint32_t press_raw;
    float pressf;
    char cmd[4];
 
    cmd[0] = 0xf7; // press_msb
    i2c.write(address, cmd, 1);
    i2c.read(address, &cmd[1], 3);
 
    press_raw = (cmd[1] << 12) | (cmd[2] << 4) | (cmd[3] >> 4);
 
    int32_t var1, var2;
    uint32_t press;
 
    var1 = (t_fine >> 1) - 64000;
    var2 = (((var1 >> 2) * (var1 >> 2)) >> 11) * dig_P6;
    var2 = var2 + ((var1 * dig_P5) << 1);
    var2 = (var2 >> 2) + (dig_P4 << 16);
    var1 = (((dig_P3 * (((var1 >> 2)*(var1 >> 2)) >> 13)) >> 3) + ((dig_P2 * var1) >> 1)) >> 18;
    var1 = ((32768 + var1) * dig_P1) >> 15;
    if (var1 == 0) {
        return 0;
    }
    press = (((1048576 - press_raw) - (var2 >> 12))) * 3125;
    if(press < 0x80000000) {
        press = (press << 1) / var1;
    } else {
        press = (press / var1) * 2;
    }
    var1 = ((int32_t)dig_P9 * ((int32_t)(((press >> 3) * (press >> 3)) >> 13))) >> 12;
    var2 = (((int32_t)(press >> 2)) * (int32_t)dig_P8) >> 13;
    press = (press + ((var1 + var2 + dig_P7) >> 4));
 
    pressf = (float)press;
    return (pressf/100.0f);
}
 
float test_BMX055::getHumidity()
{
    uint32_t hum_raw;
    float humf;
    char cmd[4];
 
    cmd[0] = 0xfd; // hum_msb
    i2c.write(address, cmd, 1);
    i2c.read(address, &cmd[1], 2);
 
    hum_raw = (cmd[1] << 8) | cmd[2];
 
    int32_t v_x1;
 
    v_x1 = t_fine - 76800;
    v_x1 =  (((((hum_raw << 14) -(((int32_t)dig_H4) << 20) - (((int32_t)dig_H5) * v_x1)) +
               ((int32_t)16384)) >> 15) * (((((((v_x1 * (int32_t)dig_H6) >> 10) *
                                            (((v_x1 * ((int32_t)dig_H3)) >> 11) + 32768)) >> 10) + 2097152) *
                                            (int32_t)dig_H2 + 8192) >> 14));
    v_x1 = (v_x1 - (((((v_x1 >> 15) * (v_x1 >> 15)) >> 7) * (int32_t)dig_H1) >> 4));
    v_x1 = (v_x1 < 0 ? 0 : v_x1);
    v_x1 = (v_x1 > 419430400 ? 419430400 : v_x1);
 
    humf = (float)(v_x1 >> 12);
 
    return (humf/1024.0f);
}
/*
void test_BMX055::initiate_pres()
{
 
    i2c_mem_write(PRES_ADDRESS, CTRL_HUM, 0x01);
    i2c_mem_write(PRES_ADDRESS, CONFIG, 0xa0);
 
    //dig_T1
    int dig_t1_Low = i2c_mem_read(PRES_ADDRESS,DIG_T1_LOW_REGS);
    int dig_t1_High = i2c_mem_read(PRES_ADDRESS,DIG_T1_HIGH_REGS);
    dig_T1 = uint16_t(dig_t1_Low + 256 * dig_t1_High);

    //dig_T2
    int dig_t2_Low = i2c_mem_read(PRES_ADDRESS, DIG_T2_LOW_REGS);
    int dig_t2_High = i2c_mem_read(PRES_ADDRESS, DIG_T2_HIGH_REGS);
    dig_T2 = int16_t(dig_t2_Low + 256 * dig_t2_High);
    
    //dig_T3
    int dig_t3_Low = i2c_mem_read(PRES_ADDRESS, DIG_T3_LOW_REGS);
    int dig_t3_High = i2c_mem_read(PRES_ADDRESS, DIG_T3_HIGH_REGS);
    dig_T3 = int16_t(dig_t3_Low + 256 * dig_t3_High);
 
 
    //Pressure

    //dig_P1
    int dig_p1_Low = i2c_mem_read(PRES_ADDRESS, DIG_P1_LOW_REGS);
    int dig_p1_High = i2c_mem_read(PRES_ADDRESS, DIG_P1_HIGH_REGS);
    dig_P1 = uint16_t(dig_p1_Low + 256 * dig_p1_High);

    //dig_P2
    int dig_p2_Low = i2c_mem_read(PRES_ADDRESS, DIG_P2_LOW_REGS);
    int dig_p2_High = i2c_mem_read(PRES_ADDRESS, DIG_P2_HIGH_REGS);
    dig_P2 = int16_t(dig_p2_Low + 256 * dig_p2_High);
    
    //dig_P3
    int dig_p3_Low = i2c_mem_read(PRES_ADDRESS, DIG_P3_LOW_REGS);
    int dig_p3_High = i2c_mem_read(PRES_ADDRESS, DIG_P3_HIGH_REGS);
    dig_P3 = int16_t(dig_p3_Low + 256 * dig_p3_High);

    //dig_P4
    int dig_p4_Low = i2c_mem_read(PRES_ADDRESS, DIG_P4_LOW_REGS);
    int dig_p4_High = i2c_mem_read(PRES_ADDRESS, DIG_P4_HIGH_REGS);
    dig_P4 = int16_t(dig_p4_Low + 256 * dig_p4_High);
    
    //dig_P5
    int dig_p5_Low = i2c_mem_read(PRES_ADDRESS, DIG_P5_LOW_REGS);
    int dig_p5_High = i2c_mem_read(PRES_ADDRESS, DIG_P5_HIGH_REGS);
    dig_P5 = int16_t(dig_p5_Low + 256 * dig_p5_High);
    
    //dig_P6
    int dig_p6_Low = i2c_mem_read(PRES_ADDRESS, DIG_P6_LOW_REGS);
    int dig_p6_High = i2c_mem_read(PRES_ADDRESS, DIG_P6_HIGH_REGS);
    dig_P6 = int16_t(dig_p6_Low + 256 * dig_p6_High);
    
    //dig_P7
    int dig_p7_Low = i2c_mem_read(PRES_ADDRESS, DIG_P7_LOW_REGS);
    int dig_p7_High = i2c_mem_read(PRES_ADDRESS, DIG_P7_HIGH_REGS);
    dig_P7 = int16_t(dig_p7_Low + 256 * dig_p7_High);
    
    //dig_P8
    int dig_p8_Low = i2c_mem_read(PRES_ADDRESS, DIG_P8_LOW_REGS);
    int dig_p8_High = i2c_mem_read(PRES_ADDRESS, DIG_P8_HIGH_REGS);
    dig_P8 = int16_t(dig_p8_Low + 256 * dig_p8_High);
    
    //dig_P9
    int dig_p9_Low = i2c_mem_read(PRES_ADDRESS, DIG_P9_LOW_REGS);
    int dig_p9_High = i2c_mem_read(PRES_ADDRESS, DIG_P9_HIGH_REGS);
    dig_P9 = int16_t(dig_p2_Low + 256 * dig_p9_High);
    
    
    //Humid
    //dig_H1
    dig_H1 = uint16_t(i2c_mem_read(PRES_ADDRESS, HUD_H1_REGS));
    
    //dig_H2
    int dig_h2_Low = i2c_mem_read(PRES_ADDRESS, HUD_H2_LOW_REGS);
    int dig_h2_High = i2c_mem_read(PRES_ADDRESS, HUD_H2_HIGH_REGS);
    dig_H2 = int16_t(dig_h2_Low + 256 * dig_h2_High);
    
    //dig_H3
    dig_H3 = uint16_t(i2c_mem_read(PRES_ADDRESS, HUD_H3_REGS));    
    
    //dig_H4
    int dig_h4_Low = i2c_mem_read(PRES_ADDRESS, HUD_H4_LOW_REGS);
    int dig_h4_High = i2c_mem_read(PRES_ADDRESS, HUD_H4_HIGH_REGS);
    dig_H4 = int16_t((dig_h4_High << 4) | (dig_h4_Low & 0x0f));
    
    //HUD_H5_HIGH_REGS
    int dig_h5_High = i2c_mem_read(PRES_ADDRESS, HUD_H5_HIGH_REGS);
    dig_H5 = int16_t((dig_h5_High << 4) | ((dig_h4_Low>>4) & 0x0f));
    
    //HUD H6
    dig_H6 = int16_t(i2c_mem_read(PRES_ADDRESS, HUD_H6_REGS));
 
}

float test_BMX055::getTemperature()
{
    uint32_t temp_raw;
    float tempf;
    
    //Tempreture raw data
    int temp_XLow = i2c_mem_read(PRES_ADDRESS, TEMP_XLSB);
    int temp_Low = i2c_mem_read(PRES_ADDRESS, TEMP_LSB);
    int temp_High = i2c_mem_read(PRES_ADDRESS, TEMP_MSB);

    temp_raw = (temp_High << 12) | (temp_Low << 4) | (temp_XLow >> 4);    
 
    int32_t temp;
 
    temp =
        (((((temp_raw >> 3) - (dig_T1 << 1))) * dig_T2) >> 11) +
        ((((((temp_raw >> 4) - dig_T1) * ((temp_raw >> 4) - dig_T1)) >> 12) * dig_T3) >> 14);
 
    t_fine = temp;
    temp = (temp * 5 + 128) >> 8;
    tempf = (float)temp;
 
    return (tempf/100.0f);
}

float test_BMX055::getPressure()
{
    uint32_t press_raw;
    float pressf;
 
    int press_XLow = i2c_mem_read(PRES_ADDRESS, PRES_XLSB);
    int press_Low = i2c_mem_read(PRES_ADDRESS, PRES_LSB);
    int press_High = i2c_mem_read(PRES_ADDRESS, PRES_MSB);
 
    press_raw = (press_High << 12) | (press_Low << 4) | (press_XLow >> 4);
 
    int32_t var1, var2;
    uint32_t press;
 
    var1 = (t_fine >> 1) - 64000;
    var2 = (((var1 >> 2) * (var1 >> 2)) >> 11) * dig_P6;
    var2 = var2 + ((var1 * dig_P5) << 1);
    var2 = (var2 >> 2) + (dig_P4 << 16);
    var1 = (((dig_P3 * (((var1 >> 2)*(var1 >> 2)) >> 13)) >> 3) + ((dig_P2 * var1) >> 1)) >> 18;
    var1 = ((32768 + var1) * dig_P1) >> 15;
    if (var1 == 0) {
        return 0;
    }
    press = (((1048576 - press_raw) - (var2 >> 12))) * 3125;
    if(press < 0x80000000) {
        press = (press << 1) / var1;
    } else {
        press = (press / var1) * 2;
    }
    var1 = ((int32_t)dig_P9 * ((int32_t)(((press >> 3) * (press >> 3)) >> 13))) >> 12;
    var2 = (((int32_t)(press >> 2)) * (int32_t)dig_P8) >> 13;
    press = (press + ((var1 + var2 + dig_P7) >> 4));
 
    pressf = (float)press;
    return (pressf/100.0f);
}

float test_BMX055::getHumidity()
{
    uint32_t hum_raw;
    float humf;
 
    int hud_Low = i2c_mem_read(PRES_ADDRESS, HUM_LSB);
    int hud_High = i2c_mem_read(PRES_ADDRESS, HUM_MSB);
 
    hum_raw = (hud_High << 8) | hud_Low;
 
    int32_t v_x1;
 
    v_x1 = t_fine - 76800;
    v_x1 =  (((((hum_raw << 14) -(((int32_t)dig_H4) << 20) - (((int32_t)dig_H5) * v_x1)) +
               ((int32_t)16384)) >> 15) * (((((((v_x1 * (int32_t)dig_H6) >> 10) *
                                            (((v_x1 * ((int32_t)dig_H3)) >> 11) + 32768)) >> 10) + 2097152) *
                                            (int32_t)dig_H2 + 8192) >> 14));
    v_x1 = (v_x1 - (((((v_x1 >> 15) * (v_x1 >> 15)) >> 7) * (int32_t)dig_H1) >> 4));
    v_x1 = (v_x1 < 0 ? 0 : v_x1);
    v_x1 = (v_x1 > 419430400 ? 419430400 : v_x1);
 
    humf = (float)(v_x1 >> 12);
 
    return (humf/1024.0f);
}
*/