#pragma once
#include "mbed.h"

class Matrix;

class Vector {
public:
    Vector(int dim);
    ~Vector();
    Vector(const Vector& v);

    Vector& operator=(const Vector& v);
    Vector operator+();
    Vector operator-();
    Vector& operator*=(float c);
    Vector& operator/=(float c);
    Vector& operator+=(const Vector& v);
    Vector& operator-=(const Vector& v);

    void SetComp(int dimNo, float val);
    void SetComps(float* vals);
    float GetNorm() const;
    Vector Normalize() const;
    Vector GetParaCompTo(Vector v);
    Vector GetPerpCompTo(Vector v);

    inline int GetDim() const {
        return dim;
    }

    inline const float* GetpComponents() const {
        return (const float*)components;
    }

    inline float GetComp(int dimNo) const {
        if (dimNo > dim) error("Index Out of Bounds Error !!");
        return components[dimNo-1];
    }

    void CleanUp();

private:
    int dim;
    float* components;

    Vector& operator*=(const Matrix& m);
    Vector& operator*=(const Vector& m);
};

Vector operator+(const Vector& lhv, const Vector& rhv);
Vector operator-(const Vector& lhv, const Vector& rhv);
Vector Cross(const Vector& lhv, const Vector& rhv);
Vector operator*(const float c, const Vector& rhv);
Vector operator*(const Vector& lhv, const float c);
float operator*(const Vector& lhv, const Vector& rhv);

